import { defineConfig } from 'vitest/config';
import { resolve } from 'path';

export default defineConfig({
  test: {
    globals: true,
    environment: 'jsdom', // nodeからjsdomに変更
    setupFiles: ['./src/__tests__/setup.js'], // セットアップファイルを追加
    coverage: {
      provider: 'v8',
      reporter: ['text', 'json', 'html'],
      lines: 80,
      functions: 80,
      branches: 80,
      statements: 80,
      include: [
        'src/utils/**/*.js',  // ユーティリティ関数のみをカバレッジ対象に
      ],
      exclude: [
        'src/**/*.test.js',
        'src/**/fixtures/**',
        'src/__tests__/**',
        'src/background/**',  // Service Workerは除外（Chrome API依存）
        'src/content/**',     // Content Scriptは除外（DOM依存）
        'src/popup/**',       // Popupは除外（DOM依存）
      ],
    },
  },
  resolve: {
    alias: {
      '@': resolve(__dirname, './src'),
    },
  },
});
