import { vi } from 'vitest';

// Chrome APIモック
const mockTabs = {
  create: vi.fn(() => Promise.resolve({ id: 1 })),
  update: vi.fn(() => Promise.resolve()),
  get: vi.fn(() => Promise.resolve({ id: 1 })),
  sendMessage: vi.fn(() => Promise.resolve({ success: true })),
  query: vi.fn(() => Promise.resolve([{ id: 1, url: 'https://example.com' }])),
  onUpdated: {
    addListener: vi.fn(),
    removeListener: vi.fn()
  }
};

const mockStorage = {
  local: {
    get: vi.fn(() => Promise.resolve({})),
    set: vi.fn(() => Promise.resolve()),
    remove: vi.fn(() => Promise.resolve())
  }
};

const mockRuntime = {
  sendMessage: vi.fn(() => Promise.resolve({ success: true })),
  onMessage: {
    addListener: vi.fn(),
    removeListener: vi.fn()
  },
  onInstalled: {
    addListener: vi.fn()
  },
  onStartup: {
    addListener: vi.fn()
  },
  getURL: vi.fn((path) => `chrome-extension://test/${path}`)
};

const mockAction = {
  setBadgeText: vi.fn(),
  setBadgeBackgroundColor: vi.fn()
};

const mockContextMenus = {
  create: vi.fn(),
  removeAll: vi.fn(() => Promise.resolve())
};

const mockScripting = {
  executeScript: vi.fn(() => Promise.resolve())
};

const mockNotifications = {
  create: vi.fn(() => Promise.resolve())
};

// グローバルにchrome APIを定義
global.chrome = {
  tabs: mockTabs,
  storage: mockStorage,
  runtime: mockRuntime,
  action: mockAction,
  contextMenus: mockContextMenus,
  scripting: mockScripting,
  notifications: mockNotifications
};

// MutationObserverモック（jsdomには含まれているが念のため）
global.MutationObserver = class MutationObserver {
  constructor(callback) {}
  observe() {}
  disconnect() {}
};

// URLSearchParamsモック（jsdomには含まれている）
global.URLSearchParams = URLSearchParams;
