"use strict";
// autogenerated - 2026-01-06

module.exports = new Map([
  [
    "-webkit-flex-wrap",
    {
      "name": "-webkit-flex-wrap",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-flex-wrap",
      "legacyAliasOf": "flex-wrap",
      "styleDeclaration": [
        "-webkit-flex-wrap",
        "WebkitFlexWrap",
        "webkitFlexWrap"
      ],
      "extended": [],
      "syntax": "nowrap | wrap | wrap-reverse"
    }
  ],
  [
    "-webkit-line-clamp",
    {
      "name": "-webkit-line-clamp",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef--webkit-line-clamp",
      "initial": "none",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "-webkit-line-clamp",
        "WebkitLineClamp",
        "webkitLineClamp"
      ],
      "syntax": "none | <integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "-webkit-mask-box-image-outset",
    {
      "name": "-webkit-mask-box-image-outset",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-mask-box-image-outset",
      "legacyAliasOf": "mask-border-outset",
      "styleDeclaration": [
        "-webkit-mask-box-image-outset",
        "WebkitMaskBoxImageOutset",
        "webkitMaskBoxImageOutset"
      ],
      "extended": [],
      "syntax": "[ <length> | <number> ]{1,4}"
    }
  ],
  [
    "-webkit-mask-box-image-repeat",
    {
      "name": "-webkit-mask-box-image-repeat",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-mask-box-image-repeat",
      "legacyAliasOf": "mask-border-repeat",
      "styleDeclaration": [
        "-webkit-mask-box-image-repeat",
        "WebkitMaskBoxImageRepeat",
        "webkitMaskBoxImageRepeat"
      ],
      "extended": [],
      "syntax": "[ stretch | repeat | round | space ]{1,2}"
    }
  ],
  [
    "-webkit-mask-box-image-slice",
    {
      "name": "-webkit-mask-box-image-slice",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-mask-box-image-slice",
      "legacyAliasOf": "mask-border-slice",
      "styleDeclaration": [
        "-webkit-mask-box-image-slice",
        "WebkitMaskBoxImageSlice",
        "webkitMaskBoxImageSlice"
      ],
      "extended": [],
      "syntax": "[ <number> | <percentage> ]{1,4} fill?"
    }
  ],
  [
    "-webkit-mask-box-image-source",
    {
      "name": "-webkit-mask-box-image-source",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-mask-box-image-source",
      "legacyAliasOf": "mask-border-source",
      "styleDeclaration": [
        "-webkit-mask-box-image-source",
        "WebkitMaskBoxImageSource",
        "webkitMaskBoxImageSource"
      ],
      "extended": [],
      "syntax": "none | <image>"
    }
  ],
  [
    "-webkit-mask-box-image-width",
    {
      "name": "-webkit-mask-box-image-width",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-mask-box-image-width",
      "legacyAliasOf": "mask-border-width",
      "styleDeclaration": [
        "-webkit-mask-box-image-width",
        "WebkitMaskBoxImageWidth",
        "webkitMaskBoxImageWidth"
      ],
      "extended": [],
      "syntax": "[ <length-percentage> | <number> | auto ]{1,4}"
    }
  ],
  [
    "-webkit-text-fill-color",
    {
      "name": "-webkit-text-fill-color",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-fill-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "an RGBA color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-fill-color",
        "WebkitTextFillColor",
        "webkitTextFillColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "-webkit-text-size-adjust",
    {
      "name": "-webkit-text-size-adjust",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-size-adjust",
      "legacyAliasOf": "text-size-adjust",
      "styleDeclaration": [
        "-webkit-text-size-adjust",
        "WebkitTextSizeAdjust",
        "webkitTextSizeAdjust"
      ],
      "extended": [],
      "syntax": "auto | none | <percentage [0,∞]>"
    }
  ],
  [
    "-webkit-text-stroke",
    {
      "name": "-webkit-text-stroke",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-stroke",
      "initial": "See individual properties",
      "appliesTo": "See individual properties",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "See individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "See individual properties",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-stroke",
        "WebkitTextStroke",
        "webkitTextStroke"
      ],
      "syntax": "<line-width> || <color>",
      "extended": []
    }
  ],
  [
    "-webkit-text-stroke-color",
    {
      "name": "-webkit-text-stroke-color",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-stroke-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "an RGBA color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-stroke-color",
        "WebkitTextStrokeColor",
        "webkitTextStrokeColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "-webkit-text-stroke-width",
    {
      "name": "-webkit-text-stroke-width",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-stroke-width",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-stroke-width",
        "WebkitTextStrokeWidth",
        "webkitTextStrokeWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "-webkit-transform",
    {
      "name": "-webkit-transform",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-transform",
      "legacyAliasOf": "transform",
      "styleDeclaration": [
        "-webkit-transform",
        "WebkitTransform",
        "webkitTransform"
      ],
      "extended": [],
      "syntax": "none | <transform-list>"
    }
  ],
  [
    "accent-color",
    {
      "name": "accent-color",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-accent-color",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the keyword auto or a computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "accent-color",
        "accentColor"
      ],
      "syntax": "auto | <color>",
      "extended": []
    }
  ],
  [
    "align-content",
    {
      "name": "align-content",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-align-content",
      "initial": "normal",
      "appliesTo": "block containers, multicol containers, flex containers, and grid containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "align-content",
        "alignContent"
      ],
      "syntax": "normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",
      "extended": []
    }
  ],
  [
    "align-items",
    {
      "name": "align-items",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-align-items",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "align-items",
        "alignItems"
      ],
      "syntax": "normal | stretch | <baseline-position> | <overflow-position>? <self-position> | anchor-center",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "align-self",
    {
      "name": "align-self",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-align-self",
      "initial": "auto",
      "appliesTo": "flex items, grid items, and absolutely-positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "align-self",
        "alignSelf"
      ],
      "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position> | anchor-center",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "alignment-baseline",
    {
      "name": "alignment-baseline",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-alignment-baseline",
      "initial": "baseline",
      "appliesTo": "inline-level boxes, flex items, grid items, table cells, and SVG text content elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "alignment-baseline",
        "alignmentBaseline"
      ],
      "syntax": "baseline | text-bottom | alphabetic | ideographic | middle | central | mathematical | text-top",
      "extended": []
    }
  ],
  [
    "all",
    {
      "name": "all",
      "href": "https://drafts.csswg.org/css-cascade-5/#propdef-all",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "all"
      ],
      "syntax": "initial | inherit | unset | revert | revert-layer | revert-rule",
      "extended": []
    }
  ],
  [
    "anchor-name",
    {
      "name": "anchor-name",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-anchor-name",
      "initial": "none",
      "appliesTo": "all elements that generate a principal box",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "anchor-name",
        "anchorName"
      ],
      "syntax": "none | <dashed-ident>#",
      "extended": []
    }
  ],
  [
    "anchor-scope",
    {
      "name": "anchor-scope",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-anchor-scope",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "anchor-scope",
        "anchorScope"
      ],
      "syntax": "none | all | <dashed-ident>#",
      "extended": []
    }
  ],
  [
    "animation",
    {
      "name": "animation",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation"
      ],
      "syntax": "<single-animation>#",
      "extended": []
    }
  ],
  [
    "animation-composition",
    {
      "name": "animation-composition",
      "href": "https://drafts.csswg.org/css-animations-2/#propdef-animation-composition",
      "initial": "replace",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-composition",
        "animationComposition"
      ],
      "syntax": "<single-animation-composition>#",
      "extended": []
    }
  ],
  [
    "animation-delay",
    {
      "name": "animation-delay",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-delay",
      "initial": "0s",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a duration",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-delay",
        "animationDelay"
      ],
      "syntax": "<time>#",
      "extended": []
    }
  ],
  [
    "animation-direction",
    {
      "name": "animation-direction",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-direction",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-direction",
        "animationDirection"
      ],
      "syntax": "<single-animation-direction>#",
      "extended": []
    }
  ],
  [
    "animation-duration",
    {
      "name": "animation-duration",
      "href": "https://drafts.csswg.org/css-animations-2/#propdef-animation-duration",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either a time or the keyword auto",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-duration",
        "animationDuration"
      ],
      "syntax": "[ auto | <time [0s,∞]> ]#",
      "extended": []
    }
  ],
  [
    "animation-fill-mode",
    {
      "name": "animation-fill-mode",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-fill-mode",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-fill-mode",
        "animationFillMode"
      ],
      "syntax": "<single-animation-fill-mode>#",
      "extended": []
    }
  ],
  [
    "animation-iteration-count",
    {
      "name": "animation-iteration-count",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-iteration-count",
      "initial": "1",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either a number or the keyword infinite",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-iteration-count",
        "animationIterationCount"
      ],
      "syntax": "<single-animation-iteration-count>#",
      "extended": []
    }
  ],
  [
    "animation-name",
    {
      "name": "animation-name",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-name",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either a case-sensitive css identifier or the keyword none",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-name",
        "animationName"
      ],
      "syntax": "[ none | <keyframes-name> ]#",
      "extended": []
    }
  ],
  [
    "animation-play-state",
    {
      "name": "animation-play-state",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-play-state",
      "initial": "running",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-play-state",
        "animationPlayState"
      ],
      "syntax": "<single-animation-play-state>#",
      "extended": []
    }
  ],
  [
    "animation-range",
    {
      "name": "animation-range",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-animation-range",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "animation-range",
        "animationRange"
      ],
      "syntax": "[ <'animation-range-start'> <'animation-range-end'>? ]#",
      "extended": []
    }
  ],
  [
    "animation-range-end",
    {
      "name": "animation-range-end",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-animation-range-end",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "relative to the specified named timeline range if one was specified, else to the entire timeline",
      "computedValue": "list, each item either the keyword normal or a timeline range and progress percentage",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-range-end",
        "animationRangeEnd"
      ],
      "syntax": "[ normal | <length-percentage> | <timeline-range-name> <length-percentage>? ]#",
      "extended": []
    }
  ],
  [
    "animation-range-start",
    {
      "name": "animation-range-start",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-animation-range-start",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "relative to the specified named timeline range if one was specified, else to the entire timeline",
      "computedValue": "list, each item either the keyword normal or a timeline range and progress percentage",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-range-start",
        "animationRangeStart"
      ],
      "syntax": "[ normal | <length-percentage> | <timeline-range-name> <length-percentage>? ]#",
      "extended": []
    }
  ],
  [
    "animation-timeline",
    {
      "name": "animation-timeline",
      "href": "https://drafts.csswg.org/css-animations-2/#propdef-animation-timeline",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either the keyword none, the keyword auto, a case-sensitive css identifier, a computed scroll() function, or a computed view() function",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-timeline",
        "animationTimeline"
      ],
      "syntax": "<single-animation-timeline>#",
      "extended": []
    }
  ],
  [
    "animation-timing-function",
    {
      "name": "animation-timing-function",
      "href": "https://drafts.csswg.org/css-animations-1/#propdef-animation-timing-function",
      "initial": "ease",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a computed <easing-function>",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "animation-timing-function",
        "animationTimingFunction"
      ],
      "syntax": "<easing-function>#",
      "extended": []
    }
  ],
  [
    "appearance",
    {
      "name": "appearance",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-appearance",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "appearance"
      ],
      "syntax": "none | auto | base | base-select | <compat-auto> | <compat-special> | base",
      "extended": [
        "https://drafts.csswg.org/css-forms-1/"
      ]
    }
  ],
  [
    "aspect-ratio",
    {
      "name": "aspect-ratio",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-aspect-ratio",
      "initial": "auto",
      "appliesTo": "all elements except inline boxes and internal ruby or table boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword or a pair of numbers",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "aspect-ratio",
        "aspectRatio"
      ],
      "syntax": "auto || <ratio>",
      "extended": []
    }
  ],
  [
    "backface-visibility",
    {
      "name": "backface-visibility",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-backface-visibility",
      "initial": "visible",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "backface-visibility",
        "backfaceVisibility"
      ],
      "syntax": "visible | hidden",
      "extended": []
    }
  ],
  [
    "background",
    {
      "name": "background",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "background"
      ],
      "syntax": "<bg-layer>#? , <final-bg-layer>",
      "extended": []
    }
  ],
  [
    "background-attachment",
    {
      "name": "background-attachment",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-attachment",
      "initial": "scroll",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-attachment",
        "backgroundAttachment"
      ],
      "syntax": "<attachment>#",
      "extended": []
    }
  ],
  [
    "background-blend-mode",
    {
      "name": "background-blend-mode",
      "href": "https://drafts.fxtf.org/compositing-2/#propdef-background-blend-mode",
      "initial": "normal",
      "appliesTo": "All HTML elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual",
      "animatable": "no",
      "styleDeclaration": [
        "background-blend-mode",
        "backgroundBlendMode"
      ],
      "syntax": "<mix-blend-mode>#",
      "extended": []
    }
  ],
  [
    "background-clip",
    {
      "name": "background-clip",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-clip",
      "initial": "border-box",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-clip",
        "backgroundClip"
      ],
      "syntax": "<bg-clip>#",
      "extended": []
    }
  ],
  [
    "background-color",
    {
      "name": "background-color",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-color",
      "initial": "transparent",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "background-color",
        "backgroundColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "background-image",
    {
      "name": "background-image",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-image",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either an <image> or the keyword none",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-image",
        "backgroundImage"
      ],
      "syntax": "<bg-image>#",
      "extended": []
    }
  ],
  [
    "background-origin",
    {
      "name": "background-origin",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-origin",
      "initial": "padding-box",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-origin",
        "backgroundOrigin"
      ],
      "syntax": "<visual-box>#",
      "extended": []
    }
  ],
  [
    "background-position",
    {
      "name": "background-position",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-position",
      "initial": "0% 0%",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "refer to size of background positioning area minus size of background image; see text",
      "computedValue": "a list, each item a pair of offsets (horizontal and vertical) from the top left origin, each offset given as a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-position",
        "backgroundPosition"
      ],
      "syntax": "<bg-position>#",
      "extended": []
    }
  ],
  [
    "background-position-x",
    {
      "name": "background-position-x",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-position-x",
      "initial": "0%",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "refer to width of background positioning area minus width of background image",
      "computedValue": "A list, each item consisting of: an offset given as a computed <length-percentage> value, plus an origin keyword",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "logicalPropertyGroup": "background-position",
      "styleDeclaration": [
        "background-position-x",
        "backgroundPositionX"
      ],
      "syntax": "[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",
      "extended": []
    }
  ],
  [
    "background-position-y",
    {
      "name": "background-position-y",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-position-y",
      "initial": "0%",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "refer to height of background positioning area minus height of background image",
      "computedValue": "A list, each item consisting of: an offset given as a computed <length-percentage> value, plus an origin keyword",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "logicalPropertyGroup": "background-position",
      "styleDeclaration": [
        "background-position-y",
        "backgroundPositionY"
      ],
      "syntax": "[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",
      "extended": []
    }
  ],
  [
    "background-repeat",
    {
      "name": "background-repeat",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-repeat",
      "initial": "repeat",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a pair of keywords, one per dimension",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-repeat",
        "backgroundRepeat"
      ],
      "syntax": "<repeat-style>#",
      "extended": []
    }
  ],
  [
    "background-repeat-x",
    {
      "name": "background-repeat-x",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-repeat-x",
      "initial": "repeat",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "background-repeat",
      "styleDeclaration": [
        "background-repeat-x",
        "backgroundRepeatX"
      ],
      "syntax": "<repetition>#",
      "extended": []
    }
  ],
  [
    "background-repeat-y",
    {
      "name": "background-repeat-y",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-repeat-y",
      "initial": "repeat",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "background-repeat",
      "styleDeclaration": [
        "background-repeat-y",
        "backgroundRepeatY"
      ],
      "syntax": "<repetition>#",
      "extended": []
    }
  ],
  [
    "background-size",
    {
      "name": "background-size",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-size",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see text",
      "computedValue": "list, each item a pair of sizes (one per axis) each represented as either a keyword or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-size",
        "backgroundSize"
      ],
      "syntax": "<bg-size>#",
      "extended": []
    }
  ],
  [
    "baseline-shift",
    {
      "name": "baseline-shift",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-baseline-shift",
      "initial": "0",
      "appliesTo": "inline-level boxes and SVG text content elements",
      "inherited": "no",
      "percentages": "refer to the used value of line-height",
      "computedValue": "the specified keyword or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "baseline-shift",
        "baselineShift"
      ],
      "syntax": "<length-percentage> | sub | super | top | center | bottom",
      "extended": []
    }
  ],
  [
    "baseline-source",
    {
      "name": "baseline-source",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-baseline-source",
      "initial": "auto",
      "appliesTo": "inline-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "baseline-source",
        "baselineSource"
      ],
      "syntax": "auto | first | last",
      "extended": []
    }
  ],
  [
    "block-ellipsis",
    {
      "name": "block-ellipsis",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-block-ellipsis",
      "initial": "no-ellipsis",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "block-ellipsis",
        "blockEllipsis"
      ],
      "syntax": "no-ellipsis | auto | <string>",
      "extended": []
    }
  ],
  [
    "block-size",
    {
      "name": "block-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-block-size",
      "initial": "auto",
      "appliesTo": "Same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as height, width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "block-size",
        "blockSize"
      ],
      "syntax": "<'width'>",
      "extended": []
    }
  ],
  [
    "block-step",
    {
      "name": "block-step",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-block-step",
      "initial": "see individual properties",
      "appliesTo": "block-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "block-step",
        "blockStep"
      ],
      "syntax": "<'block-step-size'> || <'block-step-insert'> || <'block-step-align'> || <'block-step-round'>",
      "extended": []
    }
  ],
  [
    "block-step-align",
    {
      "name": "block-step-align",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-block-step-align",
      "initial": "auto",
      "appliesTo": "block-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "block-step-align",
        "blockStepAlign"
      ],
      "syntax": "auto | center | start | end",
      "extended": []
    }
  ],
  [
    "block-step-insert",
    {
      "name": "block-step-insert",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-block-step-insert",
      "initial": "margin-box",
      "appliesTo": "block-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "block-step-insert",
        "blockStepInsert"
      ],
      "syntax": "margin-box | padding-box | content-box",
      "extended": []
    }
  ],
  [
    "block-step-round",
    {
      "name": "block-step-round",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-block-step-round",
      "initial": "up",
      "appliesTo": "block-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "block-step-round",
        "blockStepRound"
      ],
      "syntax": "up | down | nearest",
      "extended": []
    }
  ],
  [
    "block-step-size",
    {
      "name": "block-step-size",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-block-step-size",
      "initial": "none",
      "appliesTo": "block-level boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword or absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "block-step-size",
        "blockStepSize"
      ],
      "syntax": "none | <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "bookmark-label",
    {
      "name": "bookmark-label",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-bookmark-label",
      "initial": "content(text)",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "bookmark-label",
        "bookmarkLabel"
      ],
      "syntax": "<content-list>",
      "extended": []
    }
  ],
  [
    "bookmark-level",
    {
      "name": "bookmark-level",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-bookmark-level",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none or the specified integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "bookmark-level",
        "bookmarkLevel"
      ],
      "syntax": "none | <integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "bookmark-state",
    {
      "name": "bookmark-state",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-bookmark-state",
      "initial": "open",
      "appliesTo": "block-level elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "bookmark-state",
        "bookmarkState"
      ],
      "syntax": "open | closed",
      "extended": []
    }
  ],
  [
    "border",
    {
      "name": "border",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-block",
    {
      "name": "border-block",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block",
        "borderBlock"
      ],
      "syntax": "<'border-block-start'>",
      "extended": []
    }
  ],
  [
    "border-block-color",
    {
      "name": "border-block-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-color",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-color",
        "borderBlockColor"
      ],
      "syntax": "<'border-top-color'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-block-end",
    {
      "name": "border-block-end",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-end",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-end",
        "borderBlockEnd"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-block-end-color",
    {
      "name": "border-block-end-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-end-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-block-end-color",
        "borderBlockEndColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-block-end-radius",
    {
      "name": "border-block-end-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-end-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-end-radius",
        "borderBlockEndRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-block-end-style",
    {
      "name": "border-block-end-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-end-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-block-end-style",
        "borderBlockEndStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-block-end-width",
    {
      "name": "border-block-end-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-end-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-block-end-width",
        "borderBlockEndWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-block-start",
    {
      "name": "border-block-start",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-start",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-start",
        "borderBlockStart"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-block-start-color",
    {
      "name": "border-block-start-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-start-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-block-start-color",
        "borderBlockStartColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-block-start-radius",
    {
      "name": "border-block-start-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-start-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-start-radius",
        "borderBlockStartRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-block-start-style",
    {
      "name": "border-block-start-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-start-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-block-start-style",
        "borderBlockStartStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-block-start-width",
    {
      "name": "border-block-start-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-start-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-block-start-width",
        "borderBlockStartWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-block-style",
    {
      "name": "border-block-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-style",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-style",
        "borderBlockStyle"
      ],
      "syntax": "<'border-top-style'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-block-width",
    {
      "name": "border-block-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-block-width",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-block-width",
        "borderBlockWidth"
      ],
      "syntax": "<'border-top-width'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-bottom",
    {
      "name": "border-bottom",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-bottom",
        "borderBottom"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-bottom-color",
    {
      "name": "border-bottom-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-bottom-color",
        "borderBottomColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-bottom-left-radius",
    {
      "name": "border-bottom-left-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-left-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-bottom-left-radius",
        "borderBottomLeftRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-bottom-radius",
    {
      "name": "border-bottom-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-bottom-radius",
        "borderBottomRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-bottom-right-radius",
    {
      "name": "border-bottom-right-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-right-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-bottom-right-radius",
        "borderBottomRightRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-bottom-style",
    {
      "name": "border-bottom-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-bottom-style",
        "borderBottomStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-bottom-width",
    {
      "name": "border-bottom-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-bottom-width",
        "borderBottomWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-boundary",
    {
      "name": "border-boundary",
      "href": "https://drafts.csswg.org/css-round-display-1/#propdef-border-boundary",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-boundary",
        "borderBoundary"
      ],
      "syntax": "none | parent | display",
      "extended": []
    }
  ],
  [
    "border-clip",
    {
      "name": "border-clip",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-clip",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-clip",
        "borderClip"
      ],
      "syntax": "<'border-top-clip'>",
      "extended": []
    }
  ],
  [
    "border-collapse",
    {
      "name": "border-collapse",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-border-collapse",
      "initial": "separate",
      "appliesTo": "table grid boxes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-collapse",
        "borderCollapse"
      ],
      "syntax": "separate | collapse",
      "extended": []
    }
  ],
  [
    "border-color",
    {
      "name": "border-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-color",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-color",
        "borderColor"
      ],
      "syntax": "[ <color> | <image-1D> ]{1,4}",
      "extended": []
    }
  ],
  [
    "border-end-end-radius",
    {
      "name": "border-end-end-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-end-end-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-end-end-radius",
        "borderEndEndRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-end-start-radius",
    {
      "name": "border-end-start-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-end-start-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-end-start-radius",
        "borderEndStartRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-image",
    {
      "name": "border-image",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image",
      "initial": "See individual properties",
      "appliesTo": "See individual properties",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "See individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "See individual properties",
      "styleDeclaration": [
        "border-image",
        "borderImage"
      ],
      "syntax": "<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",
      "extended": []
    }
  ],
  [
    "border-image-outset",
    {
      "name": "border-image-outset",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image-outset",
      "initial": "0",
      "appliesTo": "All elements, except internal table elements when border-collapse is collapse",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "four values, each a number or absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-image-outset",
        "borderImageOutset"
      ],
      "syntax": "[ <length [0,∞]> | <number [0,∞]> ]{1,4}",
      "extended": []
    }
  ],
  [
    "border-image-repeat",
    {
      "name": "border-image-repeat",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image-repeat",
      "initial": "stretch",
      "appliesTo": "All elements, except internal table elements when border-collapse is collapse",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "two keywords, one per axis",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-image-repeat",
        "borderImageRepeat"
      ],
      "syntax": "[ stretch | repeat | round | space ]{1,2}",
      "extended": []
    }
  ],
  [
    "border-image-slice",
    {
      "name": "border-image-slice",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image-slice",
      "initial": "100%",
      "appliesTo": "All elements, except internal table elements when border-collapse is collapse",
      "inherited": "no",
      "percentages": "refer to size of the border image",
      "computedValue": "four values, each either a number or percentage; plus a fill keyword if specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-image-slice",
        "borderImageSlice"
      ],
      "syntax": "[<number [0,∞]> | <percentage [0,∞]>]{1,4} && fill?",
      "extended": []
    }
  ],
  [
    "border-image-source",
    {
      "name": "border-image-source",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image-source",
      "initial": "none",
      "appliesTo": "All elements, except internal table elements when border-collapse is collapse",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none or the computed <image>",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-image-source",
        "borderImageSource"
      ],
      "syntax": "none | <image>",
      "extended": []
    }
  ],
  [
    "border-image-width",
    {
      "name": "border-image-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-image-width",
      "initial": "1",
      "appliesTo": "All elements, except internal table elements when border-collapse is collapse",
      "inherited": "no",
      "percentages": "Relative to width/height of the border image area",
      "computedValue": "four values, each either a number, the keyword auto, or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-image-width",
        "borderImageWidth"
      ],
      "syntax": "[ <length-percentage [0,∞]> | <number [0,∞]> | auto ]{1,4}",
      "extended": []
    }
  ],
  [
    "border-inline",
    {
      "name": "border-inline",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline",
        "borderInline"
      ],
      "syntax": "<'border-block-start'>",
      "extended": []
    }
  ],
  [
    "border-inline-color",
    {
      "name": "border-inline-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-color",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-color",
        "borderInlineColor"
      ],
      "syntax": "<'border-top-color'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-inline-end",
    {
      "name": "border-inline-end",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-end",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-end",
        "borderInlineEnd"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-inline-end-color",
    {
      "name": "border-inline-end-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-end-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-inline-end-color",
        "borderInlineEndColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-inline-end-radius",
    {
      "name": "border-inline-end-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-end-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-end-radius",
        "borderInlineEndRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-inline-end-style",
    {
      "name": "border-inline-end-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-end-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-inline-end-style",
        "borderInlineEndStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-inline-end-width",
    {
      "name": "border-inline-end-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-end-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-inline-end-width",
        "borderInlineEndWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-inline-start",
    {
      "name": "border-inline-start",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-start",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-start",
        "borderInlineStart"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-inline-start-color",
    {
      "name": "border-inline-start-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-start-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-inline-start-color",
        "borderInlineStartColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-inline-start-radius",
    {
      "name": "border-inline-start-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-start-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-start-radius",
        "borderInlineStartRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-inline-start-style",
    {
      "name": "border-inline-start-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-start-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-inline-start-style",
        "borderInlineStartStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-inline-start-width",
    {
      "name": "border-inline-start-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-start-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-inline-start-width",
        "borderInlineStartWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-inline-style",
    {
      "name": "border-inline-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-style",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-style",
        "borderInlineStyle"
      ],
      "syntax": "<'border-top-style'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-inline-width",
    {
      "name": "border-inline-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-inline-width",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-inline-width",
        "borderInlineWidth"
      ],
      "syntax": "<'border-top-width'>{1,2}",
      "extended": []
    }
  ],
  [
    "border-left",
    {
      "name": "border-left",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-left",
        "borderLeft"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-left-color",
    {
      "name": "border-left-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-left-color",
        "borderLeftColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-left-radius",
    {
      "name": "border-left-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-left-radius",
        "borderLeftRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-left-style",
    {
      "name": "border-left-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-left-style",
        "borderLeftStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-left-width",
    {
      "name": "border-left-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-left-width",
        "borderLeftWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-limit",
    {
      "name": "border-limit",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-limit",
      "initial": "all",
      "appliesTo": "all elements, except table element when border-collapse is collapse",
      "inherited": "no",
      "percentages": "relative to border-box",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-limit",
        "borderLimit"
      ],
      "syntax": "all | [ sides | corners ] <length-percentage [0,∞]>? | [ top | right | bottom | left ] <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "border-radius",
    {
      "name": "border-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-radius",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-radius",
        "borderRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,4} [ / <length-percentage [0,∞]>{1,4} ]?",
      "extended": []
    }
  ],
  [
    "border-right",
    {
      "name": "border-right",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-right",
        "borderRight"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-right-color",
    {
      "name": "border-right-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-right-color",
        "borderRightColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-right-radius",
    {
      "name": "border-right-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-right-radius",
        "borderRightRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-right-style",
    {
      "name": "border-right-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-right-style",
        "borderRightStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-right-width",
    {
      "name": "border-right-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-right-width",
        "borderRightWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-shape",
    {
      "name": "border-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-shape",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see prose",
      "computedValue": "list, each item a computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-shape",
        "borderShape"
      ],
      "syntax": "none | [ <basic-shape> <geometry-box>?]{1,2}",
      "extended": []
    }
  ],
  [
    "border-spacing",
    {
      "name": "border-spacing",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-border-spacing",
      "initial": "0px 0px",
      "appliesTo": "table grid boxes when border-collapse is separate",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "two absolute lengths",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-spacing",
        "borderSpacing"
      ],
      "syntax": "<length>{1,2}",
      "extended": []
    }
  ],
  [
    "border-start-end-radius",
    {
      "name": "border-start-end-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-start-end-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-start-end-radius",
        "borderStartEndRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-start-start-radius",
    {
      "name": "border-start-start-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-start-start-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-start-start-radius",
        "borderStartStartRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-style",
    {
      "name": "border-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-style",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-style",
        "borderStyle"
      ],
      "syntax": "<'border-top-style'>{1,4}",
      "extended": []
    }
  ],
  [
    "border-top",
    {
      "name": "border-top",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-top",
        "borderTop"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-top-color",
    {
      "name": "border-top-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-top-color",
        "borderTopColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-top-left-radius",
    {
      "name": "border-top-left-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-left-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-top-left-radius",
        "borderTopLeftRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-top-radius",
    {
      "name": "border-top-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-top-radius",
        "borderTopRadius"
      ],
      "syntax": "<length-percentage [0,∞]>{1,2} [ / <length-percentage [0,∞]>{1,2} ]?",
      "extended": []
    }
  ],
  [
    "border-top-right-radius",
    {
      "name": "border-top-right-radius",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-right-radius",
      "initial": "0",
      "appliesTo": "all elements (but see prose)",
      "inherited": "no",
      "percentages": "Refer to corresponding dimension of the border box.",
      "computedValue": "pair of computed <length-percentage> values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-radius",
      "styleDeclaration": [
        "border-top-right-radius",
        "borderTopRightRadius"
      ],
      "syntax": "<border-radius>",
      "extended": []
    }
  ],
  [
    "border-top-style",
    {
      "name": "border-top-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-top-style",
        "borderTopStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-top-width",
    {
      "name": "border-top-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-top-width",
        "borderTopWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-width",
    {
      "name": "border-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-width",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-width",
        "borderWidth"
      ],
      "syntax": "<'border-top-width'>{1,4}",
      "extended": []
    }
  ],
  [
    "bottom",
    {
      "name": "bottom",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-bottom",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "bottom"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "box-decoration-break",
    {
      "name": "box-decoration-break",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-box-decoration-break",
      "initial": "slice",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "box-decoration-break",
        "boxDecorationBreak"
      ],
      "syntax": "slice | clone",
      "extended": []
    }
  ],
  [
    "box-shadow",
    {
      "name": "box-shadow",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "see individual properties",
      "styleDeclaration": [
        "box-shadow",
        "boxShadow"
      ],
      "syntax": "<spread-shadow>#",
      "extended": []
    }
  ],
  [
    "box-shadow-blur",
    {
      "name": "box-shadow-blur",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow-blur",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a <length>",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "box-shadow-blur",
        "boxShadowBlur"
      ],
      "syntax": "<length [0,∞]>#",
      "extended": []
    }
  ],
  [
    "box-shadow-color",
    {
      "name": "box-shadow-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "box-shadow-color",
        "boxShadowColor"
      ],
      "syntax": "<color>#",
      "extended": []
    }
  ],
  [
    "box-shadow-offset",
    {
      "name": "box-shadow-offset",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow-offset",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either none or a pair of offsets (horizontal and vertical) from the element‘s box",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, treating none as 0 0 when interpolated with non-none values.",
      "styleDeclaration": [
        "box-shadow-offset",
        "boxShadowOffset"
      ],
      "syntax": "[ none | <length>{1,2} ]#",
      "extended": []
    }
  ],
  [
    "box-shadow-position",
    {
      "name": "box-shadow-position",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow-position",
      "initial": "outset",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item one of the keywords",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "box-shadow-position",
        "boxShadowPosition"
      ],
      "syntax": "[ outset | inset ]#",
      "extended": []
    }
  ],
  [
    "box-shadow-spread",
    {
      "name": "box-shadow-spread",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-box-shadow-spread",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a <length>",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "box-shadow-spread",
        "boxShadowSpread"
      ],
      "syntax": "<length>#",
      "extended": []
    }
  ],
  [
    "box-sizing",
    {
      "name": "box-sizing",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-box-sizing",
      "initial": "content-box",
      "appliesTo": "all elements that accept width or height",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "box-sizing",
        "boxSizing"
      ],
      "syntax": "content-box | border-box",
      "extended": []
    }
  ],
  [
    "box-snap",
    {
      "name": "box-snap",
      "href": "https://drafts.csswg.org/css-line-grid-1/#propdef-box-snap",
      "initial": "none",
      "appliesTo": "block-level boxes and internal table elements except table cells",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "box-snap",
        "boxSnap"
      ],
      "syntax": "none | block-start | block-end | center | baseline | last-baseline",
      "extended": []
    }
  ],
  [
    "break-after",
    {
      "name": "break-after",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-break-after",
      "initial": "auto",
      "appliesTo": "block-level boxes, grid items, flex items, table row groups, table rows (but see prose)",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "break-after",
        "breakAfter"
      ],
      "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
      "extended": []
    }
  ],
  [
    "break-before",
    {
      "name": "break-before",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-break-before",
      "initial": "auto",
      "appliesTo": "block-level boxes, grid items, flex items, table row groups, table rows (but see prose)",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "break-before",
        "breakBefore"
      ],
      "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
      "extended": []
    }
  ],
  [
    "break-inside",
    {
      "name": "break-inside",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-break-inside",
      "initial": "auto",
      "appliesTo": "all elements except inline-level boxes, internal ruby boxes, table column boxes, table column group boxes, absolutely-positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "break-inside",
        "breakInside"
      ],
      "syntax": "auto | avoid | avoid-page | avoid-column | avoid-region",
      "extended": []
    }
  ],
  [
    "caption-side",
    {
      "name": "caption-side",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-caption-side",
      "initial": "top",
      "appliesTo": "table-caption boxes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "caption-side",
        "captionSide"
      ],
      "syntax": "top | bottom",
      "extended": []
    }
  ],
  [
    "caret",
    {
      "name": "caret",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-caret",
      "initial": "auto",
      "appliesTo": "text or elements that accept text input",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "caret"
      ],
      "syntax": "<'caret-color'> || <'caret-animation'> || <'caret-shape'>",
      "extended": []
    }
  ],
  [
    "caret-color",
    {
      "name": "caret-color",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-caret-color",
      "initial": "auto",
      "appliesTo": "text or elements that accept text input",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "The computed value for auto is auto. For <color> values, see CSS Color 4 § 14. Resolving <color> Values.",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "caret-color",
        "caretColor"
      ],
      "syntax": "auto | <color>",
      "extended": []
    }
  ],
  [
    "caret-shape",
    {
      "name": "caret-shape",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-caret-shape",
      "initial": "auto",
      "appliesTo": "text or elements that accept text input",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "caret-shape",
        "caretShape"
      ],
      "syntax": "auto | bar | block | underscore",
      "extended": []
    }
  ],
  [
    "clear",
    {
      "name": "clear",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-clear",
      "initial": "none",
      "appliesTo": "block-level elements, floats, regions, pages",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "clear"
      ],
      "syntax": "inline-start | inline-end | block-start | block-end | left | right | top | bottom | both-inline | both-block | both | none",
      "extended": []
    }
  ],
  [
    "clip",
    {
      "name": "clip",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-clip",
      "initial": "auto",
      "appliesTo": "Absolutely positioned elements. In SVG, it applies to elements which establish a new viewport, pattern elements and mask elements.",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "clip"
      ],
      "syntax": "<rect()> | auto",
      "extended": []
    }
  ],
  [
    "clip-path",
    {
      "name": "clip-path",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-clip-path",
      "initial": "none",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified, but with <url> values made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "clip-path",
        "clipPath"
      ],
      "syntax": "<clip-source> | [ <basic-shape> || <geometry-box> ] | none",
      "extended": []
    }
  ],
  [
    "clip-rule",
    {
      "name": "clip-rule",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-clip-rule",
      "initial": "nonzero",
      "appliesTo": "Applies to SVG graphics elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "clip-rule",
        "clipRule"
      ],
      "syntax": "nonzero | evenodd",
      "extended": []
    }
  ],
  [
    "color",
    {
      "name": "color",
      "href": "https://drafts.csswg.org/css-color-4/#propdef-color",
      "initial": "CanvasText",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "computed color, see resolving color values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "color"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "color-adjust",
    {
      "name": "color-adjust",
      "href": "https://drafts.csswg.org/css-color-adjust-1/#propdef-color-adjust",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "color-adjust",
        "colorAdjust"
      ],
      "syntax": "<'print-color-adjust'>",
      "extended": []
    }
  ],
  [
    "color-interpolation",
    {
      "name": "color-interpolation",
      "href": "https://svgwg.org/svg2-draft/painting.html#ColorInterpolationProperty",
      "initial": "sRGB",
      "appliesTo": "container elements, graphics elements, gradient elements, ‘use’ and ‘animate’",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "color-interpolation",
        "colorInterpolation"
      ],
      "syntax": "auto | sRGB | linearRGB",
      "extended": []
    }
  ],
  [
    "color-interpolation-filters",
    {
      "name": "color-interpolation-filters",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-color-interpolation-filters",
      "initial": "linearRGB",
      "appliesTo": "All filter primitives",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "color-interpolation-filters",
        "colorInterpolationFilters"
      ],
      "syntax": "auto | sRGB | linearRGB",
      "extended": []
    }
  ],
  [
    "color-scheme",
    {
      "name": "color-scheme",
      "href": "https://drafts.csswg.org/css-color-adjust-1/#propdef-color-scheme",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword normal, or an ordered list of specified color scheme keywords",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "color-scheme",
        "colorScheme"
      ],
      "syntax": "normal | [ light | dark | <custom-ident> ]+ && only?",
      "extended": []
    }
  ],
  [
    "column-count",
    {
      "name": "column-count",
      "href": "https://drafts.csswg.org/css-multicol-2/#propdef-column-count",
      "initial": "auto",
      "appliesTo": "block containers except table wrapper boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "column-count",
        "columnCount"
      ],
      "syntax": "auto | <integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "column-fill",
    {
      "name": "column-fill",
      "href": "https://drafts.csswg.org/css-multicol-2/#propdef-column-fill",
      "initial": "balance",
      "appliesTo": "multicol containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "column-fill",
        "columnFill"
      ],
      "syntax": "auto | balance | balance-all",
      "extended": []
    }
  ],
  [
    "column-gap",
    {
      "name": "column-gap",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-column-gap",
      "initial": "normal",
      "appliesTo": "multi-column containers, flex containers, grid containers",
      "inherited": "no",
      "percentages": "see § 8.3 Percentages In gap Properties",
      "computedValue": "specified keyword, else a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "column-gap",
        "columnGap"
      ],
      "syntax": "normal | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "column-rule",
    {
      "name": "column-rule",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "column-rule",
        "columnRule"
      ],
      "syntax": "<gap-rule-list> | <gap-auto-rule-list>",
      "extended": []
    }
  ],
  [
    "column-rule-break",
    {
      "name": "column-rule-break",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule-break",
      "initial": "spanning-item",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "column-rule-break",
        "columnRuleBreak"
      ],
      "syntax": "none | spanning-item | intersection",
      "extended": []
    }
  ],
  [
    "column-rule-color",
    {
      "name": "column-rule-color",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule-color",
      "initial": "currentcolor",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list, see § 3.4.1 Interpolation behavior.",
      "styleDeclaration": [
        "column-rule-color",
        "columnRuleColor"
      ],
      "syntax": "<line-color-list> | <auto-line-color-list>",
      "extended": []
    }
  ],
  [
    "column-rule-outset",
    {
      "name": "column-rule-outset",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule-outset",
      "initial": "50%",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "refer to the crossing gap width",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "column-rule-outset",
        "columnRuleOutset"
      ],
      "syntax": "<length-percentage>",
      "extended": []
    }
  ],
  [
    "column-rule-style",
    {
      "name": "column-rule-style",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule-style",
      "initial": "none",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "column-rule-style",
        "columnRuleStyle"
      ],
      "syntax": "<line-style-list> | <auto-line-style-list>",
      "extended": []
    }
  ],
  [
    "column-rule-width",
    {
      "name": "column-rule-width",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-column-rule-width",
      "initial": "medium",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list of absolute lengths, snapped as a border width",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list, see § 3.4.1 Interpolation behavior.",
      "styleDeclaration": [
        "column-rule-width",
        "columnRuleWidth"
      ],
      "syntax": "<line-width-list> | <auto-line-width-list>",
      "extended": []
    }
  ],
  [
    "column-span",
    {
      "name": "column-span",
      "href": "https://drafts.csswg.org/css-multicol-2/#propdef-column-span",
      "initial": "none",
      "appliesTo": "in-flow block-level elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "column-span",
        "columnSpan"
      ],
      "syntax": "none | <integer [1,∞]> | all | auto",
      "extended": []
    }
  ],
  [
    "column-width",
    {
      "name": "column-width",
      "href": "https://drafts.csswg.org/css-multicol-2/#propdef-column-width",
      "initial": "auto",
      "appliesTo": "block containers except table wrapper boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword auto or an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "column-width",
        "columnWidth"
      ],
      "syntax": "auto | <length [0,∞]> | min-content | max-content | fit-content(<length-percentage>)",
      "extended": [
        "https://drafts.csswg.org/css-sizing-3/"
      ]
    }
  ],
  [
    "columns",
    {
      "name": "columns",
      "href": "https://drafts.csswg.org/css-multicol-2/#propdef-columns",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "columns"
      ],
      "syntax": "[ <'column-width'> || <'column-count'> ] [ / <'column-height'> ]?",
      "extended": []
    }
  ],
  [
    "contain",
    {
      "name": "contain",
      "href": "https://drafts.csswg.org/css-contain-2/#propdef-contain",
      "initial": "none",
      "appliesTo": "See below",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or one or more of size, layout, paint",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "contain"
      ],
      "syntax": "none | strict | content | [ [size | inline-size] || layout || style || paint ] | view-transition",
      "extended": [
        "https://drafts.csswg.org/css-view-transitions-2/"
      ]
    }
  ],
  [
    "contain-intrinsic-block-size",
    {
      "name": "contain-intrinsic-block-size",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-contain-intrinsic-block-size",
      "initial": "none",
      "appliesTo": "elements with size containment",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified, with <length> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "contain-intrinsic-size",
      "styleDeclaration": [
        "contain-intrinsic-block-size",
        "containIntrinsicBlockSize"
      ],
      "syntax": "[ auto | from-element ]? [ none | <length [0,∞]> ]",
      "extended": []
    }
  ],
  [
    "contain-intrinsic-height",
    {
      "name": "contain-intrinsic-height",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-contain-intrinsic-height",
      "initial": "none",
      "appliesTo": "elements with size containment",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified, with <length> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "contain-intrinsic-size",
      "styleDeclaration": [
        "contain-intrinsic-height",
        "containIntrinsicHeight"
      ],
      "syntax": "[ auto | from-element ]? [ none | <length [0,∞]> ]",
      "extended": []
    }
  ],
  [
    "contain-intrinsic-inline-size",
    {
      "name": "contain-intrinsic-inline-size",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-contain-intrinsic-inline-size",
      "initial": "none",
      "appliesTo": "elements with size containment",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified, with <length> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "contain-intrinsic-size",
      "styleDeclaration": [
        "contain-intrinsic-inline-size",
        "containIntrinsicInlineSize"
      ],
      "syntax": "[ auto | from-element ]? [ none | <length [0,∞]> ]",
      "extended": []
    }
  ],
  [
    "contain-intrinsic-size",
    {
      "name": "contain-intrinsic-size",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-contain-intrinsic-size",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "contain-intrinsic-size",
        "containIntrinsicSize"
      ],
      "syntax": "[ [ auto | from-element ]? [ none | <length [0,∞]> ] ]{1,2}",
      "extended": []
    }
  ],
  [
    "contain-intrinsic-width",
    {
      "name": "contain-intrinsic-width",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-contain-intrinsic-width",
      "initial": "none",
      "appliesTo": "elements with size containment",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified, with <length> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "contain-intrinsic-size",
      "styleDeclaration": [
        "contain-intrinsic-width",
        "containIntrinsicWidth"
      ],
      "syntax": "[ auto | from-element ]? [ none | <length [0,∞]> ]",
      "extended": []
    }
  ],
  [
    "container",
    {
      "name": "container",
      "href": "https://drafts.csswg.org/css-conditional-5/#propdef-container",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "container"
      ],
      "syntax": "<'container-name'> [ / <'container-type'> ]?",
      "extended": []
    }
  ],
  [
    "container-name",
    {
      "name": "container-name",
      "href": "https://drafts.csswg.org/css-conditional-5/#propdef-container-name",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none, or an ordered list of identifiers",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "container-name",
        "containerName"
      ],
      "syntax": "none | <custom-ident>+",
      "extended": []
    }
  ],
  [
    "container-type",
    {
      "name": "container-type",
      "href": "https://drafts.csswg.org/css-conditional-5/#propdef-container-type",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "container-type",
        "containerType"
      ],
      "syntax": "normal | [ [ size | inline-size ] || scroll-state ]",
      "extended": []
    }
  ],
  [
    "content",
    {
      "name": "content",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-content",
      "initial": "normal",
      "appliesTo": "all elements, tree-abiding pseudo-elements, and page margin boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "See prose below",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "content"
      ],
      "syntax": "normal | none | [ <content-replacement> | <content-list> ] [/ [ <string> | <counter> | <attr()> ]+ ]? | <element()>",
      "extended": [
        "https://drafts.csswg.org/css-gcpm-3/"
      ]
    }
  ],
  [
    "content-visibility",
    {
      "name": "content-visibility",
      "href": "https://drafts.csswg.org/css-contain-2/#propdef-content-visibility",
      "initial": "visible",
      "appliesTo": "elements for which size containment can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "see § 4.1 Animating and Interpolating content-visibility",
      "styleDeclaration": [
        "content-visibility",
        "contentVisibility"
      ],
      "syntax": "visible | auto | hidden",
      "extended": []
    }
  ],
  [
    "continue",
    {
      "name": "continue",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-continue",
      "initial": "auto",
      "appliesTo": "block containers and multicol containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "continue"
      ],
      "syntax": "auto | discard | collapse | -webkit-legacy | overflow | paginate | fragments",
      "extended": [
        "https://drafts.csswg.org/css-overflow-5/"
      ]
    }
  ],
  [
    "corner-block-end-shape",
    {
      "name": "corner-block-end-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-block-end-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-block-end-shape",
        "cornerBlockEndShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-block-start-shape",
    {
      "name": "corner-block-start-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-block-start-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-block-start-shape",
        "cornerBlockStartShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-bottom-left-shape",
    {
      "name": "corner-bottom-left-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-bottom-left-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-bottom-left-shape",
        "cornerBottomLeftShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-bottom-right-shape",
    {
      "name": "corner-bottom-right-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-bottom-right-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-bottom-right-shape",
        "cornerBottomRightShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-bottom-shape",
    {
      "name": "corner-bottom-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-bottom-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-bottom-shape",
        "cornerBottomShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-end-end-shape",
    {
      "name": "corner-end-end-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-end-end-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-end-end-shape",
        "cornerEndEndShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-end-start-shape",
    {
      "name": "corner-end-start-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-end-start-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-end-start-shape",
        "cornerEndStartShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-inline-end-shape",
    {
      "name": "corner-inline-end-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-inline-end-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-inline-end-shape",
        "cornerInlineEndShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-inline-start-shape",
    {
      "name": "corner-inline-start-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-inline-start-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-inline-start-shape",
        "cornerInlineStartShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-left-shape",
    {
      "name": "corner-left-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-left-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-left-shape",
        "cornerLeftShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-right-shape",
    {
      "name": "corner-right-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-right-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-right-shape",
        "cornerRightShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "corner-shape",
    {
      "name": "corner-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-shape",
        "cornerShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,4}",
      "extended": []
    }
  ],
  [
    "corner-start-end-shape",
    {
      "name": "corner-start-end-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-start-end-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-start-end-shape",
        "cornerStartEndShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-start-start-shape",
    {
      "name": "corner-start-start-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-start-start-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-start-start-shape",
        "cornerStartStartShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-top-left-shape",
    {
      "name": "corner-top-left-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-top-left-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-top-left-shape",
        "cornerTopLeftShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-top-right-shape",
    {
      "name": "corner-top-right-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-top-right-shape",
      "initial": "round",
      "appliesTo": "all elements where border-radius can apply",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the corresponding superellipse() value",
      "canonicalOrder": "per grammar",
      "animationType": "see superellipse interpolation",
      "logicalPropertyGroup": "corner-shape",
      "styleDeclaration": [
        "corner-top-right-shape",
        "cornerTopRightShape"
      ],
      "syntax": "<corner-shape-value>",
      "extended": []
    }
  ],
  [
    "corner-top-shape",
    {
      "name": "corner-top-shape",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-corner-top-shape",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "corner-top-shape",
        "cornerTopShape"
      ],
      "syntax": "<'corner-top-left-shape'>{1,2}",
      "extended": []
    }
  ],
  [
    "counter-increment",
    {
      "name": "counter-increment",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-counter-increment",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list, each item an identifier paired with an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "counter-increment",
        "counterIncrement"
      ],
      "syntax": "[ <counter-name> <integer>? ]+ | none",
      "extended": []
    }
  ],
  [
    "counter-reset",
    {
      "name": "counter-reset",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-counter-reset",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list, each item an identifier or a reversed() function paired with an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "counter-reset",
        "counterReset"
      ],
      "syntax": "[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",
      "extended": []
    }
  ],
  [
    "counter-set",
    {
      "name": "counter-set",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-counter-set",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list, each item an identifier paired with an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "counter-set",
        "counterSet"
      ],
      "syntax": "[ <counter-name> <integer>? ]+ | none",
      "extended": []
    }
  ],
  [
    "cue",
    {
      "name": "cue",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-cue",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "cue"
      ],
      "syntax": "<'cue-before'> <'cue-after'>?",
      "extended": []
    }
  ],
  [
    "cue-after",
    {
      "name": "cue-after",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-cue-after",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "cue-after",
        "cueAfter"
      ],
      "syntax": "<uri> <decibel>? | none",
      "extended": []
    }
  ],
  [
    "cue-before",
    {
      "name": "cue-before",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-cue-before",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "cue-before",
        "cueBefore"
      ],
      "syntax": "<uri> <decibel>? | none",
      "extended": []
    }
  ],
  [
    "cursor",
    {
      "name": "cursor",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-cursor",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified, except with any relative URLs converted to absolute",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "cursor"
      ],
      "syntax": "[<cursor-image>,]* <cursor-predefined>",
      "extended": []
    }
  ],
  [
    "direction",
    {
      "name": "direction",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-direction",
      "initial": "ltr",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "n/a",
      "animationType": "not animatable",
      "styleDeclaration": [
        "direction"
      ],
      "syntax": "ltr | rtl",
      "extended": []
    }
  ],
  [
    "display",
    {
      "name": "display",
      "href": "https://drafts.csswg.org/css-display-4/#propdef-display",
      "initial": "inline",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "a pair of keywords representing the inner and outer display types plus optional list-item flag, or a <display-internal> or <display-box> keyword; see prose in a variety of specs for computation rules",
      "canonicalOrder": "per grammar",
      "animationType": "see § 2.9 Animating and Interpolating display",
      "styleDeclaration": [
        "display"
      ],
      "syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy> | <display-outside> || [ <display-inside> | math ]",
      "extended": [
        "https://w3c.github.io/mathml-core/"
      ]
    }
  ],
  [
    "dominant-baseline",
    {
      "name": "dominant-baseline",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-dominant-baseline",
      "initial": "auto",
      "appliesTo": "block containers, inline boxes, table rows, grid containers, flex containers, and SVG text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "dominant-baseline",
        "dominantBaseline"
      ],
      "syntax": "auto | text-bottom | alphabetic | ideographic | middle | central | mathematical | hanging | text-top",
      "extended": []
    }
  ],
  [
    "dynamic-range-limit",
    {
      "name": "dynamic-range-limit",
      "href": "https://drafts.csswg.org/css-color-hdr-1/#propdef-dynamic-range-limit",
      "initial": "no-limit",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "see Computed Value for dynamic-range-limit",
      "canonicalOrder": "per grammar",
      "animationType": "by dynamic-range-limit-mix()",
      "styleDeclaration": [
        "dynamic-range-limit",
        "dynamicRangeLimit"
      ],
      "syntax": "standard | no-limit | constrained | <dynamic-range-limit-mix()>",
      "extended": []
    }
  ],
  [
    "empty-cells",
    {
      "name": "empty-cells",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-empty-cells",
      "initial": "show",
      "appliesTo": "table-cell boxes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "empty-cells",
        "emptyCells"
      ],
      "syntax": "show | hide",
      "extended": []
    }
  ],
  [
    "fill",
    {
      "name": "fill",
      "href": "https://svgwg.org/svg2-draft/painting.html#FillProperty",
      "initial": "black",
      "appliesTo": "shapes and text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified, but with <color> values computed and <url> values made absolute",
      "animationType": "by computed value",
      "styleDeclaration": [
        "fill"
      ],
      "syntax": "<paint>",
      "extended": []
    }
  ],
  [
    "fill-break",
    {
      "name": "fill-break",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-break",
      "initial": "bounding-box",
      "appliesTo": "all elements",
      "inherited": "yes?",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "fill-break",
        "fillBreak"
      ],
      "syntax": "bounding-box | slice | clone",
      "extended": []
    }
  ],
  [
    "fill-color",
    {
      "name": "fill-color",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-color",
      "initial": "currentcolor",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "fill-color",
        "fillColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "fill-image",
    {
      "name": "fill-image",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-image",
      "initial": "none",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified, with any <image> computed",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "fill-image",
        "fillImage"
      ],
      "syntax": "<paint>#",
      "extended": []
    }
  ],
  [
    "fill-opacity",
    {
      "name": "fill-opacity",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-opacity",
      "initial": "1",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the specified value converted to a <number>, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "fill-opacity",
        "fillOpacity"
      ],
      "syntax": "<'opacity'>",
      "extended": []
    }
  ],
  [
    "fill-origin",
    {
      "name": "fill-origin",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-origin",
      "initial": "match-parent",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "fill-origin",
        "fillOrigin"
      ],
      "syntax": "match-parent | fill-box | stroke-box | content-box | padding-box | border-box",
      "extended": []
    }
  ],
  [
    "fill-position",
    {
      "name": "fill-position",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-position",
      "initial": "0% 0%",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "A list, each item consisting of: a pair of offsets (horizontal and vertical) from the top left origin each given as a combination of an absolute length and a percentage",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "fill-position",
        "fillPosition"
      ],
      "syntax": "<position>#",
      "extended": []
    }
  ],
  [
    "fill-repeat",
    {
      "name": "fill-repeat",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-repeat",
      "initial": "repeat",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "A list, each item consisting of: two keywords, one per dimension",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "fill-repeat",
        "fillRepeat"
      ],
      "syntax": "<repeat-style>#",
      "extended": []
    }
  ],
  [
    "fill-rule",
    {
      "name": "fill-rule",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-rule",
      "initial": "nonzero",
      "appliesTo": "SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "fill-rule",
        "fillRule"
      ],
      "syntax": "nonzero | evenodd",
      "extended": []
    }
  ],
  [
    "fill-size",
    {
      "name": "fill-size",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-fill-size",
      "initial": "auto",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified, but with lengths made absolute and omitted auto keywords filled in",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "fill-size",
        "fillSize"
      ],
      "syntax": "<bg-size>#",
      "extended": []
    }
  ],
  [
    "filter",
    {
      "name": "filter",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-filter",
      "initial": "none",
      "appliesTo": "All elements. In SVG, it applies to container elements without the defs element, all graphics elements and the use element.",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "See prose in Animation of Filters.",
      "media": "visual",
      "styleDeclaration": [
        "filter"
      ],
      "syntax": "none | <filter-value-list>",
      "extended": []
    }
  ],
  [
    "flex",
    {
      "name": "flex",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex",
      "initial": "0 1 auto",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "by computed value type",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "flex"
      ],
      "syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
      "extended": []
    }
  ],
  [
    "flex-basis",
    {
      "name": "flex-basis",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-basis",
      "initial": "auto",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "relative to the flex container’s inner main size",
      "computedValue": "specified keyword or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "flex-basis",
        "flexBasis"
      ],
      "syntax": "content | <'width'>",
      "extended": []
    }
  ],
  [
    "flex-direction",
    {
      "name": "flex-direction",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-direction",
      "initial": "row",
      "appliesTo": "flex containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "flex-direction",
        "flexDirection"
      ],
      "syntax": "row | row-reverse | column | column-reverse",
      "extended": []
    }
  ],
  [
    "flex-flow",
    {
      "name": "flex-flow",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-flow",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "flex-flow",
        "flexFlow"
      ],
      "syntax": "<'flex-direction'> || <'flex-wrap'>",
      "extended": []
    }
  ],
  [
    "flex-grow",
    {
      "name": "flex-grow",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-grow",
      "initial": "0",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified number",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "flex-grow",
        "flexGrow"
      ],
      "syntax": "<number [0,∞]>",
      "extended": []
    }
  ],
  [
    "flex-shrink",
    {
      "name": "flex-shrink",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-shrink",
      "initial": "1",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "number",
      "styleDeclaration": [
        "flex-shrink",
        "flexShrink"
      ],
      "syntax": "<number [0,∞]>",
      "extended": []
    }
  ],
  [
    "flex-wrap",
    {
      "name": "flex-wrap",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-wrap",
      "initial": "nowrap",
      "appliesTo": "flex containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "flex-wrap",
        "flexWrap"
      ],
      "syntax": "nowrap | wrap | wrap-reverse",
      "extended": []
    }
  ],
  [
    "float",
    {
      "name": "float",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-float",
      "initial": "none",
      "appliesTo": "all elements.",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "float"
      ],
      "syntax": "block-start | block-end | inline-start | inline-end | snap-block | <snap-block()> | snap-inline | <snap-inline()> | left | right | top | bottom | none | footnote",
      "extended": [
        "https://drafts.csswg.org/css-gcpm-3/"
      ]
    }
  ],
  [
    "float-defer",
    {
      "name": "float-defer",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-float-defer",
      "initial": "none",
      "appliesTo": "floats",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword or integer",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "float-defer",
        "floatDefer"
      ],
      "syntax": "<integer> | last | none",
      "extended": []
    }
  ],
  [
    "float-offset",
    {
      "name": "float-offset",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-float-offset",
      "initial": "0",
      "appliesTo": "floats",
      "inherited": "no",
      "percentages": "see prose",
      "computedValue": "computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "float-offset",
        "floatOffset"
      ],
      "syntax": "<length-percentage>",
      "extended": []
    }
  ],
  [
    "float-reference",
    {
      "name": "float-reference",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-float-reference",
      "initial": "inline",
      "appliesTo": "all elements.",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "float-reference",
        "floatReference"
      ],
      "syntax": "inline | column | region | page",
      "extended": []
    }
  ],
  [
    "flood-color",
    {
      "name": "flood-color",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-flood-color",
      "initial": "black",
      "appliesTo": "feFlood and feDropShadow elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "flood-color",
        "floodColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "flood-opacity",
    {
      "name": "flood-opacity",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-flood-opacity",
      "initial": "1",
      "appliesTo": "feFlood and feDropShadow elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the specified value converted to a number, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "flood-opacity",
        "floodOpacity"
      ],
      "syntax": "<'opacity'>",
      "extended": []
    }
  ],
  [
    "flow-from",
    {
      "name": "flow-from",
      "href": "https://drafts.csswg.org/css-regions-1/#propdef-flow-from",
      "initial": "none",
      "appliesTo": "Non-replaced block containers. This might be expanded in future versions of the specification to allow other types of containers to receive flow content.",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "flow-from",
        "flowFrom"
      ],
      "syntax": "<custom-ident> | none",
      "extended": []
    }
  ],
  [
    "flow-into",
    {
      "name": "flow-into",
      "href": "https://drafts.csswg.org/css-regions-1/#propdef-flow-into",
      "initial": "none",
      "appliesTo": "All elements, but not pseudo-elements such as ::first-line, ::first-letter, ::before or ::after.",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "flow-into",
        "flowInto"
      ],
      "syntax": "none | <custom-ident> [element | content]?",
      "extended": []
    }
  ],
  [
    "font",
    {
      "name": "font",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font",
      "initial": "see individual properties",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "see individual properties",
      "styleDeclaration": [
        "font"
      ],
      "syntax": "[ [ <'font-style'> || <font-variant-css2> || <'font-weight'> || <font-width-css3> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'># ] | <system-family-name>",
      "extended": []
    }
  ],
  [
    "font-family",
    {
      "name": "font-family",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-family",
      "initial": "depends on user agent",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "list, each item a string and/or <generic-family> keywords",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-family",
        "fontFamily"
      ],
      "syntax": "[ <family-name> | <generic-family> ]#",
      "extended": []
    }
  ],
  [
    "font-feature-settings",
    {
      "name": "font-feature-settings",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-feature-settings",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-feature-settings",
        "fontFeatureSettings"
      ],
      "syntax": "normal | <feature-tag-value>#",
      "extended": []
    }
  ],
  [
    "font-kerning",
    {
      "name": "font-kerning",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-kerning",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-kerning",
        "fontKerning"
      ],
      "syntax": "auto | normal | none",
      "extended": []
    }
  ],
  [
    "font-language-override",
    {
      "name": "font-language-override",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-language-override",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified string or the keyword none",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-language-override",
        "fontLanguageOverride"
      ],
      "syntax": "normal | <string>",
      "extended": []
    }
  ],
  [
    "font-optical-sizing",
    {
      "name": "font-optical-sizing",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-optical-sizing",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-optical-sizing",
        "fontOpticalSizing"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "font-palette",
    {
      "name": "font-palette",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-palette",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/a",
      "computedValue": "specified keyword, identifier or <palette-mix()> function. <palette-mix()> must be simplified to a single keyword or identifier if resulting palette is equivalent.",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "font-palette",
        "fontPalette"
      ],
      "syntax": "normal | light | dark | <palette-identifier> | <palette-mix()>",
      "extended": []
    }
  ],
  [
    "font-size",
    {
      "name": "font-size",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-size",
      "initial": "medium",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "refer to parent element’s font size",
      "computedValue": "an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "font-size",
        "fontSize"
      ],
      "syntax": "<absolute-size> | <relative-size> | <length-percentage [0,∞]> | math",
      "extended": []
    }
  ],
  [
    "font-size-adjust",
    {
      "name": "font-size-adjust",
      "href": "https://drafts.csswg.org/css-fonts-5/#propdef-font-size-adjust",
      "initial": "none",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the keyword none, or a pair of a metric keyword and a <number>",
      "canonicalOrder": "per grammar",
      "animationType": "discrete if the keywords differ, otherwise by computed value type",
      "styleDeclaration": [
        "font-size-adjust",
        "fontSizeAdjust"
      ],
      "syntax": "none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number [0,∞]> ]",
      "extended": []
    }
  ],
  [
    "font-stretch",
    {
      "name": "font-stretch",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-stretch",
      "legacyAliasOf": "font-width",
      "styleDeclaration": [
        "font-stretch",
        "fontStretch"
      ],
      "extended": [],
      "syntax": "normal | <percentage [0,∞]> | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded"
    }
  ],
  [
    "font-style",
    {
      "name": "font-style",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-style",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword specified, plus angle in degrees if specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type;normal animates as oblique 0deg",
      "styleDeclaration": [
        "font-style",
        "fontStyle"
      ],
      "syntax": "normal | italic | left | right | oblique <angle [-90deg,90deg]>?",
      "extended": []
    }
  ],
  [
    "font-synthesis",
    {
      "name": "font-synthesis",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-synthesis",
      "initial": "weight style small-caps position",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-synthesis",
        "fontSynthesis"
      ],
      "syntax": "none | [ weight || style || small-caps || position]",
      "extended": []
    }
  ],
  [
    "font-synthesis-position",
    {
      "name": "font-synthesis-position",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-synthesis-position",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-synthesis-position",
        "fontSynthesisPosition"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "font-synthesis-small-caps",
    {
      "name": "font-synthesis-small-caps",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-synthesis-small-caps",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-synthesis-small-caps",
        "fontSynthesisSmallCaps"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "font-synthesis-style",
    {
      "name": "font-synthesis-style",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-synthesis-style",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "font-synthesis-style",
        "fontSynthesisStyle"
      ],
      "syntax": "auto | none | oblique-only",
      "extended": []
    }
  ],
  [
    "font-synthesis-weight",
    {
      "name": "font-synthesis-weight",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-synthesis-weight",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "font-synthesis-weight",
        "fontSynthesisWeight"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "font-variant",
    {
      "name": "font-variant",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant",
        "fontVariant"
      ],
      "syntax": "normal | none | [ [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ] || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || [ stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) ] || [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ] || [ <east-asian-variant-values> || <east-asian-width-values> || ruby ] || [ sub | super ] || [ text | emoji | unicode ] ]",
      "extended": []
    }
  ],
  [
    "font-variant-alternates",
    {
      "name": "font-variant-alternates",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-alternates",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-alternates",
        "fontVariantAlternates"
      ],
      "syntax": "normal | [ stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) ]",
      "extended": []
    }
  ],
  [
    "font-variant-caps",
    {
      "name": "font-variant-caps",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-caps",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-caps",
        "fontVariantCaps"
      ],
      "syntax": "normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",
      "extended": []
    }
  ],
  [
    "font-variant-east-asian",
    {
      "name": "font-variant-east-asian",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-east-asian",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-east-asian",
        "fontVariantEastAsian"
      ],
      "syntax": "normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
      "extended": []
    }
  ],
  [
    "font-variant-emoji",
    {
      "name": "font-variant-emoji",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-emoji",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-emoji",
        "fontVariantEmoji"
      ],
      "syntax": "normal | text | emoji | unicode",
      "extended": []
    }
  ],
  [
    "font-variant-ligatures",
    {
      "name": "font-variant-ligatures",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-ligatures",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-ligatures",
        "fontVariantLigatures"
      ],
      "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",
      "extended": []
    }
  ],
  [
    "font-variant-numeric",
    {
      "name": "font-variant-numeric",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-numeric",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-numeric",
        "fontVariantNumeric"
      ],
      "syntax": "normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",
      "extended": []
    }
  ],
  [
    "font-variant-position",
    {
      "name": "font-variant-position",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant-position",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant-position",
        "fontVariantPosition"
      ],
      "syntax": "normal | sub | super",
      "extended": []
    }
  ],
  [
    "font-variation-settings",
    {
      "name": "font-variation-settings",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variation-settings",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword normal or a list, each item a string paired with a number",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "styleDeclaration": [
        "font-variation-settings",
        "fontVariationSettings"
      ],
      "syntax": "normal | [ <opentype-tag> <number> ]#",
      "extended": []
    }
  ],
  [
    "font-weight",
    {
      "name": "font-weight",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-weight",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "a number, see below",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "font-weight",
        "fontWeight"
      ],
      "syntax": "<font-weight-absolute> | bolder | lighter",
      "extended": []
    }
  ],
  [
    "font-width",
    {
      "name": "font-width",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-width",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "Not resolved",
      "computedValue": "a percentage, see below",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "font-width",
        "fontWidth"
      ],
      "syntax": "normal | <percentage [0,∞]> | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded",
      "extended": []
    }
  ],
  [
    "footnote-display",
    {
      "name": "footnote-display",
      "href": "https://drafts.csswg.org/css-gcpm-3/#propdef-footnote-display",
      "initial": "block",
      "appliesTo": "elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "footnote-display",
        "footnoteDisplay"
      ],
      "syntax": "block | inline | compact",
      "extended": []
    }
  ],
  [
    "footnote-policy",
    {
      "name": "footnote-policy",
      "href": "https://drafts.csswg.org/css-gcpm-3/#propdef-footnote-policy",
      "initial": "auto",
      "appliesTo": "elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "footnote-policy",
        "footnotePolicy"
      ],
      "syntax": "auto | line | block",
      "extended": []
    }
  ],
  [
    "forced-color-adjust",
    {
      "name": "forced-color-adjust",
      "href": "https://drafts.csswg.org/css-color-adjust-1/#propdef-forced-color-adjust",
      "initial": "auto",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "forced-color-adjust",
        "forcedColorAdjust"
      ],
      "syntax": "auto | none | preserve-parent-color",
      "extended": []
    }
  ],
  [
    "gap",
    {
      "name": "gap",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-gap",
      "initial": "see individual properties",
      "appliesTo": "multi-column containers, flex containers, grid containers",
      "inherited": "no",
      "percentages": "refer to corresponding dimension of the content area",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "gap"
      ],
      "syntax": "<'row-gap'> <'column-gap'>?",
      "extended": []
    }
  ],
  [
    "glyph-orientation-vertical",
    {
      "name": "glyph-orientation-vertical",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-glyph-orientation-vertical",
      "initial": "n/a",
      "appliesTo": "n/a",
      "inherited": "n/a",
      "percentages": "n/a",
      "computedValue": "n/a",
      "canonicalOrder": "n/a",
      "animationType": "n/a",
      "styleDeclaration": [
        "glyph-orientation-vertical",
        "glyphOrientationVertical"
      ],
      "syntax": "auto | 0deg | 90deg | 0 | 90",
      "extended": []
    }
  ],
  [
    "grid",
    {
      "name": "grid",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid",
      "initial": "none",
      "appliesTo": "grid containers",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "grid"
      ],
      "syntax": "<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",
      "extended": []
    }
  ],
  [
    "grid-area",
    {
      "name": "grid-area",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-area",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "grid-area",
        "gridArea"
      ],
      "syntax": "<grid-line> [ / <grid-line> ]{0,3}",
      "extended": []
    }
  ],
  [
    "grid-auto-columns",
    {
      "name": "grid-auto-columns",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-auto-columns",
      "initial": "auto",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "see Track Sizing",
      "computedValue": "see Track Sizing",
      "canonicalOrder": "per grammar",
      "animationType": "if the list lengths match, by computed value type per item; discrete otherwise",
      "styleDeclaration": [
        "grid-auto-columns",
        "gridAutoColumns"
      ],
      "syntax": "<track-size>+",
      "extended": []
    }
  ],
  [
    "grid-auto-flow",
    {
      "name": "grid-auto-flow",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-auto-flow",
      "initial": "row",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-auto-flow",
        "gridAutoFlow"
      ],
      "syntax": "[ row | column ] || dense",
      "extended": []
    }
  ],
  [
    "grid-auto-rows",
    {
      "name": "grid-auto-rows",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-auto-rows",
      "initial": "auto",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "see Track Sizing",
      "computedValue": "see Track Sizing",
      "canonicalOrder": "per grammar",
      "animationType": "if the list lengths match, by computed value type per item; discrete otherwise",
      "styleDeclaration": [
        "grid-auto-rows",
        "gridAutoRows"
      ],
      "syntax": "<track-size>+",
      "extended": []
    }
  ],
  [
    "grid-column",
    {
      "name": "grid-column",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-column",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "grid-column",
        "gridColumn"
      ],
      "syntax": "<grid-line> [ / <grid-line> ]?",
      "extended": []
    }
  ],
  [
    "grid-column-end",
    {
      "name": "grid-column-end",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-column-end",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword, identifier, and/or integer",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-column-end",
        "gridColumnEnd"
      ],
      "syntax": "<grid-line>",
      "extended": []
    }
  ],
  [
    "grid-column-start",
    {
      "name": "grid-column-start",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-column-start",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword, identifier, and/or integer",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-column-start",
        "gridColumnStart"
      ],
      "syntax": "<grid-line>",
      "extended": []
    }
  ],
  [
    "grid-row",
    {
      "name": "grid-row",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-row",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "grid-row",
        "gridRow"
      ],
      "syntax": "<grid-line> [ / <grid-line> ]?",
      "extended": []
    }
  ],
  [
    "grid-row-end",
    {
      "name": "grid-row-end",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-row-end",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword, identifier, and/or integer",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-row-end",
        "gridRowEnd"
      ],
      "syntax": "<grid-line>",
      "extended": []
    }
  ],
  [
    "grid-row-start",
    {
      "name": "grid-row-start",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-row-start",
      "initial": "auto",
      "appliesTo": "grid items and absolutely-positioned boxes whose containing block is a grid container",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword, identifier, and/or integer",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-row-start",
        "gridRowStart"
      ],
      "syntax": "<grid-line>",
      "extended": []
    }
  ],
  [
    "grid-template",
    {
      "name": "grid-template",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-template",
      "initial": "none",
      "appliesTo": "grid containers",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "grid-template",
        "gridTemplate"
      ],
      "syntax": "none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",
      "extended": []
    }
  ],
  [
    "grid-template-areas",
    {
      "name": "grid-template-areas",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-template-areas",
      "initial": "none",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list of string values",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "grid-template-areas",
        "gridTemplateAreas"
      ],
      "syntax": "none | <string>+",
      "extended": []
    }
  ],
  [
    "grid-template-columns",
    {
      "name": "grid-template-columns",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-template-columns",
      "initial": "none",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "refer to corresponding dimension of the content area",
      "computedValue": "the keyword none or a computed track list",
      "canonicalOrder": "per grammar",
      "animationType": "if the list lengths match, by computed value type per item in the computed track list (see § 7.2.5 Computed Value of a Track Listing and § 7.2.3.3 Interpolation/Combination of repeat()); discrete otherwise",
      "styleDeclaration": [
        "grid-template-columns",
        "gridTemplateColumns"
      ],
      "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
      "extended": []
    }
  ],
  [
    "grid-template-rows",
    {
      "name": "grid-template-rows",
      "href": "https://drafts.csswg.org/css-grid-2/#propdef-grid-template-rows",
      "initial": "none",
      "appliesTo": "grid containers",
      "inherited": "no",
      "percentages": "refer to corresponding dimension of the content area",
      "computedValue": "the keyword none or a computed track list",
      "canonicalOrder": "per grammar",
      "animationType": "if the list lengths match, by computed value type per item in the computed track list (see § 7.2.5 Computed Value of a Track Listing and § 7.2.3.3 Interpolation/Combination of repeat()); discrete otherwise",
      "styleDeclaration": [
        "grid-template-rows",
        "gridTemplateRows"
      ],
      "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
      "extended": []
    }
  ],
  [
    "hanging-punctuation",
    {
      "name": "hanging-punctuation",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hanging-punctuation",
      "initial": "none",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "hanging-punctuation",
        "hangingPunctuation"
      ],
      "syntax": "none | [ first || [ force-end | allow-end ] || last ]",
      "extended": []
    }
  ],
  [
    "height",
    {
      "name": "height",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-height",
      "initial": "auto",
      "appliesTo": "all elements except non-replaced inlines",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type, recursing into fit-content()",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "height"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "hyphenate-character",
    {
      "name": "hyphenate-character",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphenate-character",
      "initial": "auto",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "hyphenate-character",
        "hyphenateCharacter"
      ],
      "syntax": "auto | <string>",
      "extended": []
    }
  ],
  [
    "hyphenate-limit-chars",
    {
      "name": "hyphenate-limit-chars",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphenate-limit-chars",
      "initial": "auto",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "three values, each either the auto keyword or an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "hyphenate-limit-chars",
        "hyphenateLimitChars"
      ],
      "syntax": "[ auto | <integer> ]{1,3}",
      "extended": []
    }
  ],
  [
    "hyphenate-limit-last",
    {
      "name": "hyphenate-limit-last",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphenate-limit-last",
      "initial": "none",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "hyphenate-limit-last",
        "hyphenateLimitLast"
      ],
      "syntax": "none | always | column | page | spread",
      "extended": []
    }
  ],
  [
    "hyphenate-limit-lines",
    {
      "name": "hyphenate-limit-lines",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphenate-limit-lines",
      "initial": "no-limit",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword or integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "hyphenate-limit-lines",
        "hyphenateLimitLines"
      ],
      "syntax": "no-limit | <integer>",
      "extended": []
    }
  ],
  [
    "hyphenate-limit-zone",
    {
      "name": "hyphenate-limit-zone",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphenate-limit-zone",
      "initial": "0",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "refers to length of the line box",
      "computedValue": "computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "hyphenate-limit-zone",
        "hyphenateLimitZone"
      ],
      "syntax": "<length-percentage>",
      "extended": []
    }
  ],
  [
    "hyphens",
    {
      "name": "hyphens",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-hyphens",
      "initial": "manual",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "hyphens"
      ],
      "syntax": "none | manual | auto",
      "extended": []
    }
  ],
  [
    "image-orientation",
    {
      "name": "image-orientation",
      "href": "https://drafts.csswg.org/css-images-3/#propdef-image-orientation",
      "initial": "from-image",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the specified keyword, or an <angle>, rounded and normalized (see text), plus optionally a flip keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "image-orientation",
        "imageOrientation"
      ],
      "syntax": "from-image | none | [ <angle> || flip ]",
      "extended": []
    }
  ],
  [
    "image-rendering",
    {
      "name": "image-rendering",
      "href": "https://drafts.csswg.org/css-images-3/#propdef-image-rendering",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "image-rendering",
        "imageRendering"
      ],
      "syntax": "auto | smooth | high-quality | pixelated | crisp-edges",
      "extended": []
    }
  ],
  [
    "image-resolution",
    {
      "name": "image-resolution",
      "href": "https://drafts.csswg.org/css-images-4/#propdef-image-resolution",
      "initial": "1dppx",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword(s) and/or <resolution> (possibly adjusted for snap, see below)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "image-resolution",
        "imageResolution"
      ],
      "syntax": "[ from-image || <resolution> ] && snap?",
      "extended": []
    }
  ],
  [
    "initial-letter",
    {
      "name": "initial-letter",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-initial-letter",
      "initial": "normal",
      "appliesTo": "certain inline-level boxes and ::first-letter and inside ::marker boxes (see prose)",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword normal or a number paired with an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "initial-letter",
        "initialLetter"
      ],
      "syntax": "normal | <number [1,∞]> <integer [1,∞]> | <number [1,∞]> && [ drop | raise ]?",
      "extended": []
    }
  ],
  [
    "initial-letter-align",
    {
      "name": "initial-letter-align",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-initial-letter-align",
      "initial": "alphabetic",
      "appliesTo": "certain inline-level boxes and ::first-letter and inside ::marker boxes (see prose)",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "initial-letter-align",
        "initialLetterAlign"
      ],
      "syntax": "[ border-box? [ alphabetic | ideographic | hanging | leading ]? ]!",
      "extended": []
    }
  ],
  [
    "initial-letter-wrap",
    {
      "name": "initial-letter-wrap",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-initial-letter-wrap",
      "initial": "none",
      "appliesTo": "certain inline-level boxes and ::first-letter and inside ::marker boxes (see prose)",
      "inherited": "yes",
      "percentages": "relative to logical width of (last fragment of) initial letter",
      "computedValue": "specified keyword or computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "initial-letter-wrap",
        "initialLetterWrap"
      ],
      "syntax": "none | first | all | grid | <length-percentage>",
      "extended": []
    }
  ],
  [
    "inline-size",
    {
      "name": "inline-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-inline-size",
      "initial": "auto",
      "appliesTo": "Same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as height, width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "inline-size",
        "inlineSize"
      ],
      "syntax": "<'width'>",
      "extended": []
    }
  ],
  [
    "inline-sizing",
    {
      "name": "inline-sizing",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-inline-sizing",
      "initial": "normal",
      "appliesTo": "inline boxes, but not ruby container boxes nor internal ruby boxes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "inline-sizing",
        "inlineSizing"
      ],
      "syntax": "normal | stretch",
      "extended": []
    }
  ],
  [
    "inset",
    {
      "name": "inset",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "inset"
      ],
      "syntax": "<'top'>{1,4}",
      "extended": []
    }
  ],
  [
    "inset-block",
    {
      "name": "inset-block",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-block",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "inset-block",
        "insetBlock"
      ],
      "syntax": "<'top'>{1,2}",
      "extended": []
    }
  ],
  [
    "inset-block-end",
    {
      "name": "inset-block-end",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-block-end",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "inset-block-end",
        "insetBlockEnd"
      ],
      "syntax": "auto | <length-percentage>",
      "extended": []
    }
  ],
  [
    "inset-block-start",
    {
      "name": "inset-block-start",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-block-start",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "inset-block-start",
        "insetBlockStart"
      ],
      "syntax": "auto | <length-percentage>",
      "extended": []
    }
  ],
  [
    "inset-inline",
    {
      "name": "inset-inline",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-inline",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "inset-inline",
        "insetInline"
      ],
      "syntax": "<'top'>{1,2}",
      "extended": []
    }
  ],
  [
    "inset-inline-end",
    {
      "name": "inset-inline-end",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-inline-end",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "inset-inline-end",
        "insetInlineEnd"
      ],
      "syntax": "auto | <length-percentage>",
      "extended": []
    }
  ],
  [
    "inset-inline-start",
    {
      "name": "inset-inline-start",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-inset-inline-start",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "inset-inline-start",
        "insetInlineStart"
      ],
      "syntax": "auto | <length-percentage>",
      "extended": []
    }
  ],
  [
    "interpolate-size",
    {
      "name": "interpolate-size",
      "href": "https://drafts.csswg.org/css-values-5/#propdef-interpolate-size",
      "initial": "numeric-only",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "interpolate-size",
        "interpolateSize"
      ],
      "syntax": "numeric-only | allow-keywords",
      "extended": []
    }
  ],
  [
    "isolation",
    {
      "name": "isolation",
      "href": "https://drafts.fxtf.org/compositing-2/#propdef-isolation",
      "initial": "auto",
      "appliesTo": "All elements. In SVG, it applies to container elements, graphics elements and graphics referencing elements. [SVG11]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual",
      "animatable": "no",
      "styleDeclaration": [
        "isolation"
      ],
      "syntax": "<isolation-mode>",
      "extended": []
    }
  ],
  [
    "item-cross",
    {
      "name": "item-cross",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-cross",
      "initial": "auto",
      "appliesTo": "flex containers, grid containers, masonry containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "item-cross",
        "itemCross"
      ],
      "syntax": "[ auto | nowrap | wrap ] || [ normal | reverse ] | wrap-reverse",
      "extended": []
    }
  ],
  [
    "item-direction",
    {
      "name": "item-direction",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-direction",
      "initial": "auto",
      "appliesTo": "flex containers, grid containers, masonry containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "item-direction",
        "itemDirection"
      ],
      "syntax": "auto | row | column | row-reverse | column-reverse",
      "extended": []
    }
  ],
  [
    "item-flow",
    {
      "name": "item-flow",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-flow",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "item-flow",
        "itemFlow"
      ],
      "syntax": "<'item-direction'> || <'item-wrap'> || <'item-pack'> || <'item-tolerance'>",
      "extended": []
    }
  ],
  [
    "item-pack",
    {
      "name": "item-pack",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-pack",
      "initial": "normal",
      "appliesTo": "flex containers, grid containers, masonry containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "item-pack",
        "itemPack"
      ],
      "syntax": "normal | dense || balance",
      "extended": []
    }
  ],
  [
    "item-track",
    {
      "name": "item-track",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-track",
      "initial": "auto",
      "appliesTo": "flex containers, grid containers, masonry containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "item-track",
        "itemTrack"
      ],
      "syntax": "auto | row | column | row-reverse | column-reverse",
      "extended": []
    }
  ],
  [
    "item-wrap",
    {
      "name": "item-wrap",
      "href": "https://drafts.csswg.org/css-grid-3/#propdef-item-wrap",
      "initial": "auto",
      "appliesTo": "flex containers, grid containers, masonry containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "item-wrap",
        "itemWrap"
      ],
      "syntax": "[ auto | nowrap | wrap ] || [ normal | reverse ] | wrap-reverse",
      "extended": []
    }
  ],
  [
    "justify-content",
    {
      "name": "justify-content",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-justify-content",
      "initial": "normal",
      "appliesTo": "multicol containers, flex containers, and grid containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "justify-content",
        "justifyContent"
      ],
      "syntax": "normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",
      "extended": []
    }
  ],
  [
    "justify-items",
    {
      "name": "justify-items",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-justify-items",
      "initial": "legacy",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s), except for legacy (see prose)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "justify-items",
        "justifyItems"
      ],
      "syntax": "normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ] | anchor-center",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "justify-self",
    {
      "name": "justify-self",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-justify-self",
      "initial": "auto",
      "appliesTo": "block-level boxes, absolutely-positioned boxes, and grid items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "justify-self",
        "justifySelf"
      ],
      "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | anchor-center",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "left",
    {
      "name": "left",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-left",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "left"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "letter-spacing",
    {
      "name": "letter-spacing",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-letter-spacing",
      "initial": "normal",
      "appliesTo": "inline boxes and text",
      "inherited": "yes",
      "percentages": "relative to computed font-size, i.e. 1em",
      "computedValue": "an absolute length and/or a percentage",
      "canonicalOrder": "n/a",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "letter-spacing",
        "letterSpacing"
      ],
      "syntax": "normal | <length-percentage>",
      "extended": []
    }
  ],
  [
    "lighting-color",
    {
      "name": "lighting-color",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-lighting-color",
      "initial": "white",
      "appliesTo": "feDiffuseLighting and feSpecularLighting elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "lighting-color",
        "lightingColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "line-break",
    {
      "name": "line-break",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-line-break",
      "initial": "auto",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "line-break",
        "lineBreak"
      ],
      "syntax": "auto | loose | normal | strict | anywhere",
      "extended": []
    }
  ],
  [
    "line-clamp",
    {
      "name": "line-clamp",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-line-clamp",
      "initial": "none",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "line-clamp",
        "lineClamp"
      ],
      "syntax": "none | [<integer [1,∞]> || <'block-ellipsis'>] -webkit-legacy?",
      "extended": []
    }
  ],
  [
    "line-fit-edge",
    {
      "name": "line-fit-edge",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-line-fit-edge",
      "initial": "leading",
      "appliesTo": "inline boxes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "line-fit-edge",
        "lineFitEdge"
      ],
      "syntax": "leading | <text-edge>",
      "extended": []
    }
  ],
  [
    "line-grid",
    {
      "name": "line-grid",
      "href": "https://drafts.csswg.org/css-line-grid-1/#propdef-line-grid",
      "initial": "match-parent",
      "appliesTo": "block, flex and grid containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "line-grid",
        "lineGrid"
      ],
      "syntax": "match-parent | create",
      "extended": []
    }
  ],
  [
    "line-height",
    {
      "name": "line-height",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-line-height",
      "initial": "normal",
      "appliesTo": "non-replaced inline boxes and SVG text content elements",
      "inherited": "yes",
      "percentages": "computed relative to 1em",
      "computedValue": "the specified keyword, a number, or a computed <length> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "line-height",
        "lineHeight"
      ],
      "syntax": "normal | <number [0,∞]> | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "line-height-step",
    {
      "name": "line-height-step",
      "href": "https://drafts.csswg.org/css-rhythm-1/#propdef-line-height-step",
      "initial": "0",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "line-height-step",
        "lineHeightStep"
      ],
      "syntax": "<length [0,∞]>",
      "extended": []
    }
  ],
  [
    "line-padding",
    {
      "name": "line-padding",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-line-padding",
      "initial": "0",
      "appliesTo": "inline boxes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "line-padding",
        "linePadding"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "line-snap",
    {
      "name": "line-snap",
      "href": "https://drafts.csswg.org/css-line-grid-1/#propdef-line-snap",
      "initial": "none",
      "appliesTo": "block container elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "line-snap",
        "lineSnap"
      ],
      "syntax": "none | baseline | contain",
      "extended": []
    }
  ],
  [
    "list-style",
    {
      "name": "list-style",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-list-style",
      "initial": "see individual properties",
      "appliesTo": "list items",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "list-style",
        "listStyle"
      ],
      "syntax": "<'list-style-position'> || <'list-style-image'> || <'list-style-type'>",
      "extended": []
    }
  ],
  [
    "list-style-image",
    {
      "name": "list-style-image",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-list-style-image",
      "initial": "none",
      "appliesTo": "list items",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword noneor the computed <image>",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "list-style-image",
        "listStyleImage"
      ],
      "syntax": "<image> | none",
      "extended": []
    }
  ],
  [
    "list-style-position",
    {
      "name": "list-style-position",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-list-style-position",
      "initial": "outside",
      "appliesTo": "list items",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "keyword, but see prose",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "list-style-position",
        "listStylePosition"
      ],
      "syntax": "inside | outside",
      "extended": []
    }
  ],
  [
    "list-style-type",
    {
      "name": "list-style-type",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-list-style-type",
      "initial": "disc",
      "appliesTo": "list items",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "list-style-type",
        "listStyleType"
      ],
      "syntax": "<counter-style> | <string> | none",
      "extended": []
    }
  ],
  [
    "margin",
    {
      "name": "margin",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "margin"
      ],
      "syntax": "<'margin-top'>{1,4}",
      "extended": []
    }
  ],
  [
    "margin-block",
    {
      "name": "margin-block",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-block",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "margin-block",
        "marginBlock"
      ],
      "syntax": "<'margin-top'>{1,2}",
      "extended": []
    }
  ],
  [
    "margin-block-end",
    {
      "name": "margin-block-end",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-block-end",
      "initial": "0",
      "appliesTo": "Same as margin-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding margin-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-block-end",
        "marginBlockEnd"
      ],
      "syntax": "<'margin-top'>",
      "extended": []
    }
  ],
  [
    "margin-block-start",
    {
      "name": "margin-block-start",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-block-start",
      "initial": "0",
      "appliesTo": "Same as margin-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding margin-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-block-start",
        "marginBlockStart"
      ],
      "syntax": "<'margin-top'>",
      "extended": []
    }
  ],
  [
    "margin-bottom",
    {
      "name": "margin-bottom",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-bottom",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-bottom",
        "marginBottom"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-break",
    {
      "name": "margin-break",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-margin-break",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "margin-break",
        "marginBreak"
      ],
      "syntax": "auto | keep | discard",
      "extended": []
    }
  ],
  [
    "margin-inline",
    {
      "name": "margin-inline",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-inline",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "margin-inline",
        "marginInline"
      ],
      "syntax": "<'margin-top'>{1,2}",
      "extended": []
    }
  ],
  [
    "margin-inline-end",
    {
      "name": "margin-inline-end",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-inline-end",
      "initial": "0",
      "appliesTo": "Same as margin-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding margin-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-inline-end",
        "marginInlineEnd"
      ],
      "syntax": "<'margin-top'>",
      "extended": []
    }
  ],
  [
    "margin-inline-start",
    {
      "name": "margin-inline-start",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-margin-inline-start",
      "initial": "0",
      "appliesTo": "Same as margin-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding margin-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-inline-start",
        "marginInlineStart"
      ],
      "syntax": "<'margin-top'>",
      "extended": []
    }
  ],
  [
    "margin-left",
    {
      "name": "margin-left",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-left",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-left",
        "marginLeft"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-right",
    {
      "name": "margin-right",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-right",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-right",
        "marginRight"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-top",
    {
      "name": "margin-top",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-top",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-top",
        "marginTop"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-trim",
    {
      "name": "margin-trim",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-trim",
      "initial": "none",
      "appliesTo": "block containers, multi-column containers, flex containers, grid containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "a set of zero to four keywords indicating which sides to trim",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "margin-trim",
        "marginTrim"
      ],
      "syntax": "none | [ block || inline ] | [ block-start || inline-start || block-end || inline-end ]",
      "extended": []
    }
  ],
  [
    "marker",
    {
      "name": "marker",
      "href": "https://svgwg.org/svg2-draft/painting.html#MarkerProperty",
      "initial": "not defined for shorthand properties",
      "appliesTo": "shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "styleDeclaration": [
        "marker"
      ],
      "syntax": "none | <marker-ref>",
      "extended": []
    }
  ],
  [
    "marker-end",
    {
      "name": "marker-end",
      "href": "https://svgwg.org/svg2-draft/painting.html#MarkerEndProperty",
      "initial": "none",
      "appliesTo": "shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified, but with <url> values (that are part of a <marker-ref>) made absolute",
      "animationType": "discrete",
      "styleDeclaration": [
        "marker-end",
        "markerEnd"
      ],
      "syntax": "none | <marker-ref>",
      "extended": []
    }
  ],
  [
    "marker-mid",
    {
      "name": "marker-mid",
      "href": "https://svgwg.org/svg2-draft/painting.html#MarkerMidProperty",
      "initial": "none",
      "appliesTo": "shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified, but with <url> values (that are part of a <marker-ref>) made absolute",
      "animationType": "discrete",
      "styleDeclaration": [
        "marker-mid",
        "markerMid"
      ],
      "syntax": "none | <marker-ref>",
      "extended": []
    }
  ],
  [
    "marker-side",
    {
      "name": "marker-side",
      "href": "https://drafts.csswg.org/css-lists-3/#propdef-marker-side",
      "initial": "match-self",
      "appliesTo": "list items",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "marker-side",
        "markerSide"
      ],
      "syntax": "match-self | match-parent",
      "extended": []
    }
  ],
  [
    "marker-start",
    {
      "name": "marker-start",
      "href": "https://svgwg.org/svg2-draft/painting.html#MarkerStartProperty",
      "initial": "none",
      "appliesTo": "shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified, but with <url> values (that are part of a <marker-ref>) made absolute",
      "animationType": "discrete",
      "styleDeclaration": [
        "marker-start",
        "markerStart"
      ],
      "syntax": "none | <marker-ref>",
      "extended": []
    }
  ],
  [
    "mask",
    {
      "name": "mask",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask",
      "initial": "see individual properties",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "see individual properties",
      "media": "visual",
      "styleDeclaration": [
        "mask"
      ],
      "syntax": "<mask-layer>#",
      "extended": []
    }
  ],
  [
    "mask-border",
    {
      "name": "mask-border",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border",
      "initial": "See individual properties",
      "appliesTo": "See individual properties",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "See individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "See individual properties",
      "media": "visual",
      "styleDeclaration": [
        "mask-border",
        "maskBorder"
      ],
      "syntax": "<'mask-border-source'> || <'mask-border-slice'> [ / <'mask-border-width'>? [ / <'mask-border-outset'> ]? ]? || <'mask-border-repeat'> || <'mask-border-mode'>",
      "extended": []
    }
  ],
  [
    "mask-border-mode",
    {
      "name": "mask-border-mode",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-mode",
      "initial": "alpha",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-mode",
        "maskBorderMode"
      ],
      "syntax": "luminance | alpha",
      "extended": []
    }
  ],
  [
    "mask-border-outset",
    {
      "name": "mask-border-outset",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-outset",
      "initial": "0",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "all <length>s made absolute, otherwise as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-outset",
        "maskBorderOutset"
      ],
      "syntax": "[ <length> | <number> ]{1,4}",
      "extended": []
    }
  ],
  [
    "mask-border-repeat",
    {
      "name": "mask-border-repeat",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-repeat",
      "initial": "stretch",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-repeat",
        "maskBorderRepeat"
      ],
      "syntax": "[ stretch | repeat | round | space ]{1,2}",
      "extended": []
    }
  ],
  [
    "mask-border-slice",
    {
      "name": "mask-border-slice",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-slice",
      "initial": "0",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "refer to size of the mask border image",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-slice",
        "maskBorderSlice"
      ],
      "syntax": "[ <number> | <percentage> ]{1,4} fill?",
      "extended": []
    }
  ],
  [
    "mask-border-source",
    {
      "name": "mask-border-source",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-source",
      "initial": "none",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "they keyword none or the computed <image>",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-source",
        "maskBorderSource"
      ],
      "syntax": "none | <image>",
      "extended": []
    }
  ],
  [
    "mask-border-width",
    {
      "name": "mask-border-width",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-border-width",
      "initial": "auto",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "relative to width/height of the mask border image area",
      "computedValue": "all <length>s made absolute, otherwise as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "mask-border-width",
        "maskBorderWidth"
      ],
      "syntax": "[ <length-percentage> | <number> | auto ]{1,4}",
      "extended": []
    }
  ],
  [
    "mask-clip",
    {
      "name": "mask-clip",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-clip",
      "initial": "border-box",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-clip",
        "maskClip"
      ],
      "syntax": "[ <coord-box> | no-clip ]#",
      "extended": []
    }
  ],
  [
    "mask-composite",
    {
      "name": "mask-composite",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-composite",
      "initial": "add",
      "appliesTo": "All elements. In SVG, it applies to container elements without the defs element and all graphics elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-composite",
        "maskComposite"
      ],
      "syntax": "<compositing-operator>#",
      "extended": []
    }
  ],
  [
    "mask-image",
    {
      "name": "mask-image",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-image",
      "initial": "none",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item the keyword none, a computed <image>, or a computed <url>",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-image",
        "maskImage"
      ],
      "syntax": "<mask-reference>#",
      "extended": []
    }
  ],
  [
    "mask-mode",
    {
      "name": "mask-mode",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-mode",
      "initial": "match-source",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-mode",
        "maskMode"
      ],
      "syntax": "<masking-mode>#",
      "extended": []
    }
  ],
  [
    "mask-origin",
    {
      "name": "mask-origin",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-origin",
      "initial": "border-box",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-origin",
        "maskOrigin"
      ],
      "syntax": "<coord-box>#",
      "extended": []
    }
  ],
  [
    "mask-position",
    {
      "name": "mask-position",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-position",
      "initial": "0% 0%",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "refer to size of mask painting area minus size of mask layer image; see text background-position [CSS3BG]",
      "computedValue": "list, each item consists of two keywords representing the origin and two offsets from that origin, each given as an absolute length (if given a <length>), otherwise as a percentage.",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "mask-position",
        "maskPosition"
      ],
      "syntax": "<position>#",
      "extended": []
    }
  ],
  [
    "mask-repeat",
    {
      "name": "mask-repeat",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-repeat",
      "initial": "repeat",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item a pair of keywords, one per dimension",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-repeat",
        "maskRepeat"
      ],
      "syntax": "<repeat-style>#",
      "extended": []
    }
  ],
  [
    "mask-size",
    {
      "name": "mask-size",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-size",
      "initial": "auto",
      "appliesTo": "All elements. In SVG, it applies to container elements excluding the defs element, all graphics elements and the use element",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list, each item as specified, but with lengths made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "mask-size",
        "maskSize"
      ],
      "syntax": "<bg-size>#",
      "extended": []
    }
  ],
  [
    "mask-type",
    {
      "name": "mask-type",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-mask-type",
      "initial": "luminance",
      "appliesTo": "mask elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "mask-type",
        "maskType"
      ],
      "syntax": "luminance | alpha",
      "extended": []
    }
  ],
  [
    "max-block-size",
    {
      "name": "max-block-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-max-block-size",
      "initial": "none",
      "appliesTo": "same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as max-height, max-width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "max-size",
      "styleDeclaration": [
        "max-block-size",
        "maxBlockSize"
      ],
      "syntax": "<'max-width'>",
      "extended": []
    }
  ],
  [
    "max-height",
    {
      "name": "max-height",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-max-height",
      "initial": "none",
      "appliesTo": "all elements that accept width or height",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, recursing into fit-content()",
      "logicalPropertyGroup": "max-size",
      "styleDeclaration": [
        "max-height",
        "maxHeight"
      ],
      "syntax": "none | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "max-inline-size",
    {
      "name": "max-inline-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-max-inline-size",
      "initial": "none",
      "appliesTo": "same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as max-height, max-width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "max-size",
      "styleDeclaration": [
        "max-inline-size",
        "maxInlineSize"
      ],
      "syntax": "<'max-width'>",
      "extended": []
    }
  ],
  [
    "max-lines",
    {
      "name": "max-lines",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-max-lines",
      "initial": "none",
      "appliesTo": "block containers which are also either line-clamp containers or fragmentation containers that capture region breaks",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none or an integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "max-lines",
        "maxLines"
      ],
      "syntax": "none | <integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "max-width",
    {
      "name": "max-width",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-max-width",
      "initial": "none",
      "appliesTo": "all elements that accept width or height",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, recursing into fit-content()",
      "logicalPropertyGroup": "max-size",
      "styleDeclaration": [
        "max-width",
        "maxWidth"
      ],
      "syntax": "none | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "min-block-size",
    {
      "name": "min-block-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-min-block-size",
      "initial": "0",
      "appliesTo": "same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as min-height, min-width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "min-size",
      "styleDeclaration": [
        "min-block-size",
        "minBlockSize"
      ],
      "syntax": "<'min-width'>",
      "extended": []
    }
  ],
  [
    "min-height",
    {
      "name": "min-height",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-min-height",
      "initial": "auto",
      "appliesTo": "all elements that accept width or height",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, recursing into fit-content()",
      "logicalPropertyGroup": "min-size",
      "styleDeclaration": [
        "min-height",
        "minHeight"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "min-inline-size",
    {
      "name": "min-inline-size",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-min-inline-size",
      "initial": "0",
      "appliesTo": "same as height and width",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as min-height, min-width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "min-size",
      "styleDeclaration": [
        "min-inline-size",
        "minInlineSize"
      ],
      "syntax": "<'min-width'>",
      "extended": []
    }
  ],
  [
    "min-intrinsic-sizing",
    {
      "name": "min-intrinsic-sizing",
      "href": "https://drafts.csswg.org/css-sizing-4/#propdef-min-intrinsic-sizing",
      "initial": "legacy",
      "appliesTo": "all elements except inline boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "min-intrinsic-sizing",
        "minIntrinsicSizing"
      ],
      "syntax": "legacy | zero-if-scroll || zero-if-extrinsic",
      "extended": []
    }
  ],
  [
    "min-width",
    {
      "name": "min-width",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-min-width",
      "initial": "auto",
      "appliesTo": "all elements that accept width or height",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, recursing into fit-content()",
      "logicalPropertyGroup": "min-size",
      "styleDeclaration": [
        "min-width",
        "minWidth"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "mix-blend-mode",
    {
      "name": "mix-blend-mode",
      "href": "https://drafts.fxtf.org/compositing-2/#propdef-mix-blend-mode",
      "initial": "normal",
      "appliesTo": "All elements. In SVG, it applies to container elements, graphics elements and graphics referencing elements. [SVG11]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual",
      "animatable": "no",
      "styleDeclaration": [
        "mix-blend-mode",
        "mixBlendMode"
      ],
      "syntax": "<blend-mode> | plus-darker | plus-lighter",
      "extended": []
    }
  ],
  [
    "nav-down",
    {
      "name": "nav-down",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-nav-down",
      "initial": "auto",
      "appliesTo": "all enabled elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "nav-down",
        "navDown"
      ],
      "syntax": "auto | <id> [ current | root | <target-name> ]?",
      "extended": []
    }
  ],
  [
    "nav-left",
    {
      "name": "nav-left",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-nav-left",
      "initial": "auto",
      "appliesTo": "all enabled elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "nav-left",
        "navLeft"
      ],
      "syntax": "auto | <id> [ current | root | <target-name> ]?",
      "extended": []
    }
  ],
  [
    "nav-right",
    {
      "name": "nav-right",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-nav-right",
      "initial": "auto",
      "appliesTo": "all enabled elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "nav-right",
        "navRight"
      ],
      "syntax": "auto | <id> [ current | root | <target-name> ]?",
      "extended": []
    }
  ],
  [
    "nav-up",
    {
      "name": "nav-up",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-nav-up",
      "initial": "auto",
      "appliesTo": "all enabled elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "nav-up",
        "navUp"
      ],
      "syntax": "auto | <id> [ current | root | <target-name> ]?",
      "extended": []
    }
  ],
  [
    "object-fit",
    {
      "name": "object-fit",
      "href": "https://drafts.csswg.org/css-images-4/#propdef-object-fit",
      "initial": "fill",
      "appliesTo": "replaced elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "object-fit",
        "objectFit"
      ],
      "syntax": "fill | none | [contain | cover] || scale-down",
      "extended": []
    }
  ],
  [
    "object-position",
    {
      "name": "object-position",
      "href": "https://drafts.csswg.org/css-images-3/#propdef-object-position",
      "initial": "50% 50%",
      "appliesTo": "replaced elements",
      "inherited": "no",
      "percentages": "refer to width and height of element itself",
      "computedValue": "as for background-position",
      "canonicalOrder": "the horizontal component of the <position>, followed by the vertical component",
      "animationType": "as for background-position",
      "styleDeclaration": [
        "object-position",
        "objectPosition"
      ],
      "syntax": "<position>",
      "extended": []
    }
  ],
  [
    "offset",
    {
      "name": "offset",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset",
      "initial": "see individual properties",
      "appliesTo": "transformable elements",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "offset"
      ],
      "syntax": "[ <'offset-position'>? [ <'offset-path'> [ <'offset-distance'> || <'offset-rotate'> ]? ]? ]! [ / <'offset-anchor'> ]?",
      "extended": []
    }
  ],
  [
    "offset-anchor",
    {
      "name": "offset-anchor",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset-anchor",
      "initial": "auto",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "relative to the width and the height of the element’s reference box",
      "computedValue": "the auto keyword or a computed <position>",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "offset-anchor",
        "offsetAnchor"
      ],
      "syntax": "auto | <position>",
      "extended": []
    }
  ],
  [
    "offset-distance",
    {
      "name": "offset-distance",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset-distance",
      "initial": "0",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "relative to the offset path length",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "offset-distance",
        "offsetDistance"
      ],
      "syntax": "<length-percentage>",
      "extended": []
    }
  ],
  [
    "offset-path",
    {
      "name": "offset-path",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset-path",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "offset-path",
        "offsetPath"
      ],
      "syntax": "none | <offset-path> || <coord-box>",
      "extended": []
    }
  ],
  [
    "offset-position",
    {
      "name": "offset-position",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset-position",
      "initial": "normal",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "Refer to the size of containing block",
      "computedValue": "The normal or auto keywords, or a computed <position>",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "offset-position",
        "offsetPosition"
      ],
      "syntax": "normal | auto | <position>",
      "extended": []
    }
  ],
  [
    "offset-rotate",
    {
      "name": "offset-rotate",
      "href": "https://drafts.fxtf.org/motion-1/#propdef-offset-rotate",
      "initial": "auto",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "computed <angle> value, optionally preceded by auto",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "offset-rotate",
        "offsetRotate"
      ],
      "syntax": "[ auto | reverse ] || <angle>",
      "extended": []
    }
  ],
  [
    "opacity",
    {
      "name": "opacity",
      "href": "https://drafts.csswg.org/css-color-4/#propdef-opacity",
      "initial": "1",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "map to the range [0,1]",
      "computedValue": "specified number, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "opacity"
      ],
      "syntax": "<opacity-value>",
      "extended": []
    }
  ],
  [
    "order",
    {
      "name": "order",
      "href": "https://drafts.csswg.org/css-display-4/#propdef-order",
      "initial": "0",
      "appliesTo": "flex items and grid items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "order"
      ],
      "syntax": "<integer>",
      "extended": []
    }
  ],
  [
    "orphans",
    {
      "name": "orphans",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-orphans",
      "initial": "2",
      "appliesTo": "block containers that establish an inline formatting context",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "orphans"
      ],
      "syntax": "<integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "outline",
    {
      "name": "outline",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "outline"
      ],
      "syntax": "<'outline-width'> || <'outline-style'> || <'outline-color'>",
      "extended": []
    }
  ],
  [
    "outline-color",
    {
      "name": "outline-color",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline-color",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see below",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "outline-color",
        "outlineColor"
      ],
      "syntax": "auto | <'border-top-color'>",
      "extended": []
    }
  ],
  [
    "outline-offset",
    {
      "name": "outline-offset",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline-offset",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "outline-offset",
        "outlineOffset"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "outline-style",
    {
      "name": "outline-style",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline-style",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "outline-style",
        "outlineStyle"
      ],
      "syntax": "auto | <outline-line-style>",
      "extended": []
    }
  ],
  [
    "outline-width",
    {
      "name": "outline-width",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline-width",
      "initial": "medium",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "outline-width",
        "outlineWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "overflow",
    {
      "name": "overflow",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-overflow",
      "initial": "visible",
      "appliesTo": "block containers [CSS2], flex containers [CSS3-FLEXBOX], and grid containers [CSS3-GRID-LAYOUT]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "overflow"
      ],
      "syntax": "<'overflow-block'>{1,2}",
      "extended": []
    }
  ],
  [
    "overflow-anchor",
    {
      "name": "overflow-anchor",
      "href": "https://drafts.csswg.org/css-scroll-anchoring-1/#propdef-overflow-anchor",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "overflow-anchor",
        "overflowAnchor"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "overflow-block",
    {
      "name": "overflow-block",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-overflow-block",
      "initial": "visible",
      "appliesTo": "block containers [CSS2], flex containers [CSS3-FLEXBOX], grid containers [CSS3-GRID-LAYOUT]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "usually specified value, but see text",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overflow",
      "styleDeclaration": [
        "overflow-block",
        "overflowBlock"
      ],
      "syntax": "visible | hidden | clip | scroll | auto",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin",
    {
      "name": "overflow-clip-margin",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "overflow-clip-margin",
        "overflowClipMargin"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-block",
    {
      "name": "overflow-clip-margin-block",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-block",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "overflow-clip-margin-block",
        "overflowClipMarginBlock"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-block-end",
    {
      "name": "overflow-clip-margin-block-end",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-block-end",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-block-end",
        "overflowClipMarginBlockEnd"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-block-start",
    {
      "name": "overflow-clip-margin-block-start",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-block-start",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-block-start",
        "overflowClipMarginBlockStart"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-bottom",
    {
      "name": "overflow-clip-margin-bottom",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-bottom",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-bottom",
        "overflowClipMarginBottom"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-inline",
    {
      "name": "overflow-clip-margin-inline",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-inline",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "overflow-clip-margin-inline",
        "overflowClipMarginInline"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-inline-end",
    {
      "name": "overflow-clip-margin-inline-end",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-inline-end",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-inline-end",
        "overflowClipMarginInlineEnd"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-inline-start",
    {
      "name": "overflow-clip-margin-inline-start",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-inline-start",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-inline-start",
        "overflowClipMarginInlineStart"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-left",
    {
      "name": "overflow-clip-margin-left",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-left",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-left",
        "overflowClipMarginLeft"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-right",
    {
      "name": "overflow-clip-margin-right",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-right",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-right",
        "overflowClipMarginRight"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-clip-margin-top",
    {
      "name": "overflow-clip-margin-top",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-overflow-clip-margin-top",
      "initial": "0px",
      "appliesTo": "boxes to which overflow applies",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "the computed <length> and a <visual-box> keyword",
      "animationType": "per computed value if the <visual-box> values match; otherwise discrete",
      "canonicalOrder": "per grammar",
      "logicalPropertyGroup": "overflow-clip-margin",
      "styleDeclaration": [
        "overflow-clip-margin-top",
        "overflowClipMarginTop"
      ],
      "syntax": "<visual-box> || <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "overflow-inline",
    {
      "name": "overflow-inline",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-overflow-inline",
      "initial": "visible",
      "appliesTo": "block containers [CSS2], flex containers [CSS3-FLEXBOX], grid containers [CSS3-GRID-LAYOUT]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "usually specified value, but see text",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overflow",
      "styleDeclaration": [
        "overflow-inline",
        "overflowInline"
      ],
      "syntax": "visible | hidden | clip | scroll | auto",
      "extended": []
    }
  ],
  [
    "overflow-wrap",
    {
      "name": "overflow-wrap",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-overflow-wrap",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "overflow-wrap",
        "overflowWrap"
      ],
      "syntax": "normal | break-word | anywhere",
      "extended": []
    }
  ],
  [
    "overflow-x",
    {
      "name": "overflow-x",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-overflow-x",
      "initial": "visible",
      "appliesTo": "block containers [CSS2], flex containers [CSS3-FLEXBOX], grid containers [CSS3-GRID-LAYOUT]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "usually specified value, but see text",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overflow",
      "styleDeclaration": [
        "overflow-x",
        "overflowX"
      ],
      "syntax": "visible | hidden | clip | scroll | auto",
      "extended": []
    }
  ],
  [
    "overflow-y",
    {
      "name": "overflow-y",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-overflow-y",
      "initial": "visible",
      "appliesTo": "block containers [CSS2], flex containers [CSS3-FLEXBOX], grid containers [CSS3-GRID-LAYOUT]",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "usually specified value, but see text",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overflow",
      "styleDeclaration": [
        "overflow-y",
        "overflowY"
      ],
      "syntax": "visible | hidden | clip | scroll | auto",
      "extended": []
    }
  ],
  [
    "overlay",
    {
      "name": "overlay",
      "href": "https://drafts.csswg.org/css-position-4/#propdef-overlay",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "styleDeclaration": [
        "overlay"
      ],
      "syntax": "none | auto",
      "extended": []
    }
  ],
  [
    "overscroll-behavior",
    {
      "name": "overscroll-behavior",
      "href": "https://drafts.csswg.org/css-overscroll-1/#propdef-overscroll-behavior",
      "initial": "auto auto",
      "appliesTo": "scroll container elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "overscroll-behavior",
        "overscrollBehavior"
      ],
      "syntax": "[ contain | none | auto ]{1,2}",
      "extended": []
    }
  ],
  [
    "overscroll-behavior-block",
    {
      "name": "overscroll-behavior-block",
      "href": "https://drafts.csswg.org/css-overscroll-1/#propdef-overscroll-behavior-block",
      "initial": "auto",
      "appliesTo": "scroll container elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overscroll-behavior",
      "media": "visual",
      "styleDeclaration": [
        "overscroll-behavior-block",
        "overscrollBehaviorBlock"
      ],
      "syntax": "contain | none | auto",
      "extended": []
    }
  ],
  [
    "overscroll-behavior-inline",
    {
      "name": "overscroll-behavior-inline",
      "href": "https://drafts.csswg.org/css-overscroll-1/#propdef-overscroll-behavior-inline",
      "initial": "auto",
      "appliesTo": "scroll container elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overscroll-behavior",
      "media": "visual",
      "styleDeclaration": [
        "overscroll-behavior-inline",
        "overscrollBehaviorInline"
      ],
      "syntax": "contain | none | auto",
      "extended": []
    }
  ],
  [
    "overscroll-behavior-x",
    {
      "name": "overscroll-behavior-x",
      "href": "https://drafts.csswg.org/css-overscroll-1/#propdef-overscroll-behavior-x",
      "initial": "auto",
      "appliesTo": "scroll container elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overscroll-behavior",
      "media": "visual",
      "styleDeclaration": [
        "overscroll-behavior-x",
        "overscrollBehaviorX"
      ],
      "syntax": "contain | none | auto",
      "extended": []
    }
  ],
  [
    "overscroll-behavior-y",
    {
      "name": "overscroll-behavior-y",
      "href": "https://drafts.csswg.org/css-overscroll-1/#propdef-overscroll-behavior-y",
      "initial": "auto",
      "appliesTo": "scroll container elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "overscroll-behavior",
      "media": "visual",
      "styleDeclaration": [
        "overscroll-behavior-y",
        "overscrollBehaviorY"
      ],
      "syntax": "contain | none | auto",
      "extended": []
    }
  ],
  [
    "padding",
    {
      "name": "padding",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "padding"
      ],
      "syntax": "<'padding-top'>{1,4}",
      "extended": []
    }
  ],
  [
    "padding-block",
    {
      "name": "padding-block",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-block",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "padding-block",
        "paddingBlock"
      ],
      "syntax": "<'padding-top'>{1,2}",
      "extended": []
    }
  ],
  [
    "padding-block-end",
    {
      "name": "padding-block-end",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-block-end",
      "initial": "0",
      "appliesTo": "Same as padding-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding padding-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-block-end",
        "paddingBlockEnd"
      ],
      "syntax": "<'padding-top'>",
      "extended": []
    }
  ],
  [
    "padding-block-start",
    {
      "name": "padding-block-start",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-block-start",
      "initial": "0",
      "appliesTo": "Same as padding-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding padding-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-block-start",
        "paddingBlockStart"
      ],
      "syntax": "<'padding-top'>",
      "extended": []
    }
  ],
  [
    "padding-bottom",
    {
      "name": "padding-bottom",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-bottom",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-bottom",
        "paddingBottom"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-inline",
    {
      "name": "padding-inline",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-inline",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "padding-inline",
        "paddingInline"
      ],
      "syntax": "<'padding-top'>{1,2}",
      "extended": []
    }
  ],
  [
    "padding-inline-end",
    {
      "name": "padding-inline-end",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-inline-end",
      "initial": "0",
      "appliesTo": "Same as padding-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding padding-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-inline-end",
        "paddingInlineEnd"
      ],
      "syntax": "<'padding-top'>",
      "extended": []
    }
  ],
  [
    "padding-inline-start",
    {
      "name": "padding-inline-start",
      "href": "https://drafts.csswg.org/css-logical-1/#propdef-padding-inline-start",
      "initial": "0",
      "appliesTo": "Same as padding-top",
      "inherited": "no",
      "percentages": "As for the corresponding physical property",
      "computedValue": "Same as corresponding padding-* properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-inline-start",
        "paddingInlineStart"
      ],
      "syntax": "<'padding-top'>",
      "extended": []
    }
  ],
  [
    "padding-left",
    {
      "name": "padding-left",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-left",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-left",
        "paddingLeft"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-right",
    {
      "name": "padding-right",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-right",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-right",
        "paddingRight"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-top",
    {
      "name": "padding-top",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-top",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-top",
        "paddingTop"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "page",
    {
      "name": "page",
      "href": "https://drafts.csswg.org/css-page-3/#propdef-page",
      "initial": "auto",
      "appliesTo": "boxes that create class A break points",
      "inherited": "no (but see prose)",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "page"
      ],
      "syntax": "auto | <custom-ident>",
      "extended": []
    }
  ],
  [
    "page-break-after",
    {
      "name": "page-break-after",
      "href": "https://drafts.csswg.org/css2/#propdef-page-break-after",
      "initial": "auto",
      "appliesTo": "block-level elements (but see text)",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual, paged",
      "styleDeclaration": [
        "page-break-after",
        "pageBreakAfter"
      ],
      "syntax": "auto | always | avoid | left | right | inherit",
      "extended": []
    }
  ],
  [
    "page-break-before",
    {
      "name": "page-break-before",
      "href": "https://drafts.csswg.org/css2/#propdef-page-break-before",
      "initial": "auto",
      "appliesTo": "block-level elements (but see text)",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual, paged",
      "styleDeclaration": [
        "page-break-before",
        "pageBreakBefore"
      ],
      "syntax": "auto | always | avoid | left | right | inherit",
      "extended": []
    }
  ],
  [
    "page-break-inside",
    {
      "name": "page-break-inside",
      "href": "https://drafts.csswg.org/css2/#propdef-page-break-inside",
      "initial": "auto",
      "appliesTo": "block-level elements (but see text)",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual, paged",
      "styleDeclaration": [
        "page-break-inside",
        "pageBreakInside"
      ],
      "syntax": "avoid | auto | inherit",
      "extended": []
    }
  ],
  [
    "pause",
    {
      "name": "pause",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-pause",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "pause"
      ],
      "syntax": "<'pause-before'> <'pause-after'>?",
      "extended": []
    }
  ],
  [
    "pause-after",
    {
      "name": "pause-after",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-pause-after",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "pause-after",
        "pauseAfter"
      ],
      "syntax": "<time [0s,∞]> | none | x-weak | weak | medium | strong | x-strong",
      "extended": []
    }
  ],
  [
    "pause-before",
    {
      "name": "pause-before",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-pause-before",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "pause-before",
        "pauseBefore"
      ],
      "syntax": "<time [0s,∞]> | none | x-weak | weak | medium | strong | x-strong",
      "extended": []
    }
  ],
  [
    "perspective",
    {
      "name": "perspective",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-perspective",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none or an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "perspective"
      ],
      "syntax": "none | <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "perspective-origin",
    {
      "name": "perspective-origin",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-perspective-origin",
      "initial": "50% 50%",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "refer to the size of the reference box",
      "computedValue": "see background-position",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "perspective-origin",
        "perspectiveOrigin"
      ],
      "syntax": "<position>",
      "extended": []
    }
  ],
  [
    "place-content",
    {
      "name": "place-content",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-place-content",
      "initial": "normal",
      "appliesTo": "see individual properties",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "place-content",
        "placeContent"
      ],
      "syntax": "<'align-content'> <'justify-content'>?",
      "extended": []
    }
  ],
  [
    "place-items",
    {
      "name": "place-items",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-place-items",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "place-items",
        "placeItems"
      ],
      "syntax": "<'align-items'> <'justify-items'>?",
      "extended": []
    }
  ],
  [
    "place-self",
    {
      "name": "place-self",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-place-self",
      "initial": "auto",
      "appliesTo": "see individual properties",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "place-self",
        "placeSelf"
      ],
      "syntax": "<'align-self'> <'justify-self'>?",
      "extended": []
    }
  ],
  [
    "pointer-events",
    {
      "name": "pointer-events",
      "href": "https://svgwg.org/svg2-draft/interact.html#PointerEventsProperty",
      "initial": "auto",
      "appliesTo": "container elements, graphics elements and ‘use’",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "pointer-events",
        "pointerEvents"
      ],
      "syntax": "auto | bounding-box | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | none",
      "extended": []
    }
  ],
  [
    "position",
    {
      "name": "position",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-position",
      "initial": "static",
      "appliesTo": "all elements except table-column-group and table-column",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "position"
      ],
      "syntax": "static | relative | absolute | sticky | fixed | <running()>",
      "extended": [
        "https://drafts.csswg.org/css-gcpm-3/"
      ]
    }
  ],
  [
    "position-anchor",
    {
      "name": "position-anchor",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-anchor",
      "initial": "auto",
      "appliesTo": "absolutely positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "position-anchor",
        "positionAnchor"
      ],
      "syntax": "auto | <anchor-name>",
      "extended": []
    }
  ],
  [
    "position-area",
    {
      "name": "position-area",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-area",
      "initial": "none",
      "appliesTo": "positioned boxes with a default anchor box",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a pair of keywords, see § 3.1.3 Computed Value and Serialization of <position-area>",
      "canonicalOrder": "per grammar",
      "animationType": "TBD",
      "styleDeclaration": [
        "position-area",
        "positionArea"
      ],
      "syntax": "none | <position-area>",
      "extended": []
    }
  ],
  [
    "position-try",
    {
      "name": "position-try",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-try",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "position-try",
        "positionTry"
      ],
      "syntax": "<'position-try-order'>? <'position-try-fallbacks'>",
      "extended": []
    }
  ],
  [
    "position-try-fallbacks",
    {
      "name": "position-try-fallbacks",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-try-fallbacks",
      "initial": "none",
      "appliesTo": "absolutely positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "position-try-fallbacks",
        "positionTryFallbacks"
      ],
      "syntax": "none | [ [<dashed-ident> || <try-tactic>] | <position-area> ]#",
      "extended": []
    }
  ],
  [
    "position-try-order",
    {
      "name": "position-try-order",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-try-order",
      "initial": "normal",
      "appliesTo": "absolutely positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "position-try-order",
        "positionTryOrder"
      ],
      "syntax": "normal | <try-size>",
      "extended": []
    }
  ],
  [
    "position-visibility",
    {
      "name": "position-visibility",
      "href": "https://drafts.csswg.org/css-anchor-position-1/#propdef-position-visibility",
      "initial": "anchors-visible",
      "appliesTo": "absolutely positioned boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "position-visibility",
        "positionVisibility"
      ],
      "syntax": "always | [ anchors-valid || anchors-visible || no-overflow ]",
      "extended": []
    }
  ],
  [
    "print-color-adjust",
    {
      "name": "print-color-adjust",
      "href": "https://drafts.csswg.org/css-color-adjust-1/#propdef-print-color-adjust",
      "initial": "economy",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "print-color-adjust",
        "printColorAdjust"
      ],
      "syntax": "economy | exact",
      "extended": []
    }
  ],
  [
    "quotes",
    {
      "name": "quotes",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-quotes",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword none, the keyword auto or match-parent, or a list, each item a pair of string values",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "quotes"
      ],
      "syntax": "auto | none | match-parent | [ <string> <string> ]+",
      "extended": []
    }
  ],
  [
    "reading-flow",
    {
      "name": "reading-flow",
      "href": "https://drafts.csswg.org/css-display-4/#propdef-reading-flow",
      "initial": "normal",
      "appliesTo": "block, flex and grid containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "reading-flow",
        "readingFlow"
      ],
      "syntax": "normal | source-order | flex-visual | flex-flow | grid-rows | grid-columns | grid-order",
      "extended": []
    }
  ],
  [
    "region-fragment",
    {
      "name": "region-fragment",
      "href": "https://drafts.csswg.org/css-regions-1/#propdef-region-fragment",
      "initial": "auto",
      "appliesTo": "CSS Regions",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "region-fragment",
        "regionFragment"
      ],
      "syntax": "auto | break",
      "extended": []
    }
  ],
  [
    "resize",
    {
      "name": "resize",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-resize",
      "initial": "none",
      "appliesTo": "elements that are scroll containers and optionally replaced elements such as images, videos, and iframes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "resize"
      ],
      "syntax": "none | both | horizontal | vertical | block | inline",
      "extended": []
    }
  ],
  [
    "rest",
    {
      "name": "rest",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-rest",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rest"
      ],
      "syntax": "<'rest-before'> <'rest-after'>?",
      "extended": []
    }
  ],
  [
    "rest-after",
    {
      "name": "rest-after",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-rest-after",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rest-after",
        "restAfter"
      ],
      "syntax": "<time [0s,∞]> | none | x-weak | weak | medium | strong | x-strong",
      "extended": []
    }
  ],
  [
    "rest-before",
    {
      "name": "rest-before",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-rest-before",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rest-before",
        "restBefore"
      ],
      "syntax": "<time [0s,∞]> | none | x-weak | weak | medium | strong | x-strong",
      "extended": []
    }
  ],
  [
    "right",
    {
      "name": "right",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-right",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "right"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "rotate",
    {
      "name": "rotate",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-rotate",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none, or an <angle> with an axis consisting of a list of three <number>s",
      "canonicalOrder": "per grammar",
      "animationType": "as SLERP, but see below for none",
      "styleDeclaration": [
        "rotate"
      ],
      "syntax": "none | <angle> | [ x | y | z | <number>{3} ] && <angle>",
      "extended": []
    }
  ],
  [
    "row-gap",
    {
      "name": "row-gap",
      "href": "https://drafts.csswg.org/css-align-3/#propdef-row-gap",
      "initial": "normal",
      "appliesTo": "multi-column containers, flex containers, grid containers",
      "inherited": "no",
      "percentages": "see § 8.3 Percentages In gap Properties",
      "computedValue": "specified keyword, else a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "row-gap",
        "rowGap"
      ],
      "syntax": "normal | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "row-rule",
    {
      "name": "row-rule",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "row-rule",
        "rowRule"
      ],
      "syntax": "<gap-rule-list> | <gap-auto-rule-list>",
      "extended": []
    }
  ],
  [
    "row-rule-break",
    {
      "name": "row-rule-break",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule-break",
      "initial": "spanning-item",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "row-rule-break",
        "rowRuleBreak"
      ],
      "syntax": "none | spanning-item | intersection",
      "extended": []
    }
  ],
  [
    "row-rule-color",
    {
      "name": "row-rule-color",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule-color",
      "initial": "currentcolor",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list, see § 3.4.1 Interpolation behavior.",
      "styleDeclaration": [
        "row-rule-color",
        "rowRuleColor"
      ],
      "syntax": "<line-color-list> | <auto-line-color-list>",
      "extended": []
    }
  ],
  [
    "row-rule-outset",
    {
      "name": "row-rule-outset",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule-outset",
      "initial": "50%",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "refer to the crossing gap width",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "row-rule-outset",
        "rowRuleOutset"
      ],
      "syntax": "<length-percentage>",
      "extended": []
    }
  ],
  [
    "row-rule-style",
    {
      "name": "row-rule-style",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule-style",
      "initial": "none",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "row-rule-style",
        "rowRuleStyle"
      ],
      "syntax": "<line-style-list> | <auto-line-style-list>",
      "extended": []
    }
  ],
  [
    "row-rule-width",
    {
      "name": "row-rule-width",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-row-rule-width",
      "initial": "medium",
      "appliesTo": "grid containers, flex containers, multicol containers, and masonry containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "list of absolute lengths, snapped as a border width",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list, see § 3.4.1 Interpolation behavior.",
      "styleDeclaration": [
        "row-rule-width",
        "rowRuleWidth"
      ],
      "syntax": "<line-width-list> | <auto-line-width-list>",
      "extended": []
    }
  ],
  [
    "ruby-align",
    {
      "name": "ruby-align",
      "href": "https://drafts.csswg.org/css-ruby-1/#propdef-ruby-align",
      "initial": "space-around",
      "appliesTo": "ruby bases, ruby annotations, ruby base containers, ruby annotation containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "ruby-align",
        "rubyAlign"
      ],
      "syntax": "start | center | space-between | space-around",
      "extended": []
    }
  ],
  [
    "ruby-merge",
    {
      "name": "ruby-merge",
      "href": "https://drafts.csswg.org/css-ruby-1/#propdef-ruby-merge",
      "initial": "separate",
      "appliesTo": "interlinear ruby annotation containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "ruby-merge",
        "rubyMerge"
      ],
      "syntax": "separate | merge | auto",
      "extended": []
    }
  ],
  [
    "ruby-overhang",
    {
      "name": "ruby-overhang",
      "href": "https://drafts.csswg.org/css-ruby-1/#propdef-ruby-overhang",
      "initial": "auto",
      "appliesTo": "ruby annotation containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "ruby-overhang",
        "rubyOverhang"
      ],
      "syntax": "auto | none",
      "extended": []
    }
  ],
  [
    "ruby-position",
    {
      "name": "ruby-position",
      "href": "https://drafts.csswg.org/css-ruby-1/#propdef-ruby-position",
      "initial": "alternate",
      "appliesTo": "ruby annotation containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "ruby-position",
        "rubyPosition"
      ],
      "syntax": "[ alternate || [ over | under ] ] | inter-character",
      "extended": []
    }
  ],
  [
    "rule",
    {
      "name": "rule",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule and row-rule",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule"
      ],
      "syntax": "<'column-rule'>",
      "extended": []
    }
  ],
  [
    "rule-break",
    {
      "name": "rule-break",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule-break",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule-break and row-rule-break",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule-break",
        "ruleBreak"
      ],
      "syntax": "<'column-rule-break'>",
      "extended": []
    }
  ],
  [
    "rule-color",
    {
      "name": "rule-color",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule-color",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule-color and row-rule-color",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule-color",
        "ruleColor"
      ],
      "syntax": "<'column-rule-color'>",
      "extended": []
    }
  ],
  [
    "rule-outset",
    {
      "name": "rule-outset",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule-outset",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule-outset and row-rule-outset",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule-outset",
        "ruleOutset"
      ],
      "syntax": "<'column-rule-outset'>",
      "extended": []
    }
  ],
  [
    "rule-style",
    {
      "name": "rule-style",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule-style",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule-style and row-rule-style",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule-style",
        "ruleStyle"
      ],
      "syntax": "<'column-rule-style'>",
      "extended": []
    }
  ],
  [
    "rule-width",
    {
      "name": "rule-width",
      "href": "https://drafts.csswg.org/css-gaps-1/#propdef-rule-width",
      "initial": "see individual properties",
      "appliesTo": "Same as column-rule-width and row-rule-width",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "rule-width",
        "ruleWidth"
      ],
      "syntax": "<'column-rule-width'>",
      "extended": []
    }
  ],
  [
    "scale",
    {
      "name": "scale",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-scale",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none, or a list of 3 <number>s",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, but see below for none",
      "styleDeclaration": [
        "scale"
      ],
      "syntax": "none | [ <number> | <percentage> ]{1,3}",
      "extended": []
    }
  ],
  [
    "scroll-behavior",
    {
      "name": "scroll-behavior",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-scroll-behavior",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "scroll-behavior",
        "scrollBehavior"
      ],
      "syntax": "auto | smooth",
      "extended": []
    }
  ],
  [
    "scroll-margin",
    {
      "name": "scroll-margin",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "per side, an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "scroll-margin",
        "scrollMargin"
      ],
      "syntax": "<length>{1,4}",
      "extended": []
    }
  ],
  [
    "scroll-margin-block",
    {
      "name": "scroll-margin-block",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-block",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "animationType": "by computed value type",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-margin-block",
        "scrollMarginBlock"
      ],
      "syntax": "<length>{1,2}",
      "extended": []
    }
  ],
  [
    "scroll-margin-block-end",
    {
      "name": "scroll-margin-block-end",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-block-end",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-block-end",
        "scrollMarginBlockEnd"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-block-start",
    {
      "name": "scroll-margin-block-start",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-block-start",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-block-start",
        "scrollMarginBlockStart"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-bottom",
    {
      "name": "scroll-margin-bottom",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-bottom",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-bottom",
        "scrollMarginBottom"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-inline",
    {
      "name": "scroll-margin-inline",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-inline",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "see individual properties",
      "animationType": "by computed value type",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-margin-inline",
        "scrollMarginInline"
      ],
      "syntax": "<length>{1,2}",
      "extended": []
    }
  ],
  [
    "scroll-margin-inline-end",
    {
      "name": "scroll-margin-inline-end",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-inline-end",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-inline-end",
        "scrollMarginInlineEnd"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-inline-start",
    {
      "name": "scroll-margin-inline-start",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-inline-start",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-inline-start",
        "scrollMarginInlineStart"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-left",
    {
      "name": "scroll-margin-left",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-left",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-left",
        "scrollMarginLeft"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-right",
    {
      "name": "scroll-margin-right",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-right",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-right",
        "scrollMarginRight"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-margin-top",
    {
      "name": "scroll-margin-top",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-margin-top",
      "initial": "0",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-margin",
      "styleDeclaration": [
        "scroll-margin-top",
        "scrollMarginTop"
      ],
      "syntax": "<length>",
      "extended": []
    }
  ],
  [
    "scroll-marker-group",
    {
      "name": "scroll-marker-group",
      "href": "https://drafts.csswg.org/css-overflow-5/#propdef-scroll-marker-group",
      "initial": "none",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scroll-marker-group",
        "scrollMarkerGroup"
      ],
      "syntax": "none | before | after",
      "extended": []
    }
  ],
  [
    "scroll-padding",
    {
      "name": "scroll-padding",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the corresponding dimension of the scroll container’s scrollport",
      "computedValue": "per side, either the keyword auto or a computed <length-percentage> value",
      "animationType": "by computed value type",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-padding",
        "scrollPadding"
      ],
      "syntax": "[ auto | <length-percentage [0,∞]> ]{1,4}",
      "extended": []
    }
  ],
  [
    "scroll-padding-block",
    {
      "name": "scroll-padding-block",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-block",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "see individual properties",
      "animationType": "by computed value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-padding-block",
        "scrollPaddingBlock"
      ],
      "syntax": "[ auto | <length-percentage [0,∞]> ]{1,2}",
      "extended": []
    }
  ],
  [
    "scroll-padding-block-end",
    {
      "name": "scroll-padding-block-end",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-block-end",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-block-end",
        "scrollPaddingBlockEnd"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-block-start",
    {
      "name": "scroll-padding-block-start",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-block-start",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-block-start",
        "scrollPaddingBlockStart"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-bottom",
    {
      "name": "scroll-padding-bottom",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-bottom",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-bottom",
        "scrollPaddingBottom"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-inline",
    {
      "name": "scroll-padding-inline",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-inline",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "see individual properties",
      "animationType": "by computed value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-padding-inline",
        "scrollPaddingInline"
      ],
      "syntax": "[ auto | <length-percentage [0,∞]> ]{1,2}",
      "extended": []
    }
  ],
  [
    "scroll-padding-inline-end",
    {
      "name": "scroll-padding-inline-end",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-inline-end",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-inline-end",
        "scrollPaddingInlineEnd"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-inline-start",
    {
      "name": "scroll-padding-inline-start",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-inline-start",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-inline-start",
        "scrollPaddingInlineStart"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-left",
    {
      "name": "scroll-padding-left",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-left",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-left",
        "scrollPaddingLeft"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-right",
    {
      "name": "scroll-padding-right",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-right",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-right",
        "scrollPaddingRight"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-padding-top",
    {
      "name": "scroll-padding-top",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-padding-top",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "relative to the scroll container’s scrollport",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "scroll-padding",
      "styleDeclaration": [
        "scroll-padding-top",
        "scrollPaddingTop"
      ],
      "syntax": "auto | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "scroll-snap-align",
    {
      "name": "scroll-snap-align",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-snap-align",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "two keywords",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scroll-snap-align",
        "scrollSnapAlign"
      ],
      "syntax": "[ none | start | end | center ]{1,2}",
      "extended": []
    }
  ],
  [
    "scroll-snap-stop",
    {
      "name": "scroll-snap-stop",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-snap-stop",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scroll-snap-stop",
        "scrollSnapStop"
      ],
      "syntax": "normal | always",
      "extended": []
    }
  ],
  [
    "scroll-snap-type",
    {
      "name": "scroll-snap-type",
      "href": "https://drafts.csswg.org/css-scroll-snap-1/#propdef-scroll-snap-type",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scroll-snap-type",
        "scrollSnapType"
      ],
      "syntax": "none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",
      "extended": []
    }
  ],
  [
    "scroll-timeline",
    {
      "name": "scroll-timeline",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-scroll-timeline",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "not animatable",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "scroll-timeline",
        "scrollTimeline"
      ],
      "syntax": "[ <'scroll-timeline-name'> <'scroll-timeline-axis'>? ]#",
      "extended": []
    }
  ],
  [
    "scroll-timeline-axis",
    {
      "name": "scroll-timeline-axis",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-scroll-timeline-axis",
      "initial": "block",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "a list of the keywords specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "scroll-timeline-axis",
        "scrollTimelineAxis"
      ],
      "syntax": "[ block | inline | x | y ]#",
      "extended": []
    }
  ],
  [
    "scroll-timeline-name",
    {
      "name": "scroll-timeline-name",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-scroll-timeline-name",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list of CSS identifiers",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "scroll-timeline-name",
        "scrollTimelineName"
      ],
      "syntax": "[ none | <dashed-ident> ]#",
      "extended": []
    }
  ],
  [
    "scrollbar-color",
    {
      "name": "scrollbar-color",
      "href": "https://drafts.csswg.org/css-scrollbars-1/#propdef-scrollbar-color",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword or two computed colors",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "scrollbar-color",
        "scrollbarColor"
      ],
      "syntax": "auto | <color>{2}",
      "extended": []
    }
  ],
  [
    "scrollbar-gutter",
    {
      "name": "scrollbar-gutter",
      "href": "https://drafts.csswg.org/css-overflow-3/#propdef-scrollbar-gutter",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scrollbar-gutter",
        "scrollbarGutter"
      ],
      "syntax": "auto | stable && both-edges?",
      "extended": []
    }
  ],
  [
    "scrollbar-width",
    {
      "name": "scrollbar-width",
      "href": "https://drafts.csswg.org/css-scrollbars-1/#propdef-scrollbar-width",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "scrollbar-width",
        "scrollbarWidth"
      ],
      "syntax": "auto | thin | none",
      "extended": []
    }
  ],
  [
    "shape-image-threshold",
    {
      "name": "shape-image-threshold",
      "href": "https://drafts.csswg.org/css-shapes-1/#propdef-shape-image-threshold",
      "initial": "0",
      "appliesTo": "floats",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified number, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "shape-image-threshold",
        "shapeImageThreshold"
      ],
      "syntax": "<opacity-value>",
      "extended": []
    }
  ],
  [
    "shape-inside",
    {
      "name": "shape-inside",
      "href": "https://drafts.csswg.org/css-shapes-2/#propdef-shape-inside",
      "initial": "auto",
      "appliesTo": "block-level elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "computed lengths for <basic-shape>, the absolute URL for <url>, otherwise as specified",
      "canonicalOrder": "per grammar",
      "animationType": "as defined for <basic-shape>, otherwise discrete",
      "styleDeclaration": [
        "shape-inside",
        "shapeInside"
      ],
      "syntax": "auto | outside-shape | [ <basic-shape> || shape-box ] | <image> | display",
      "extended": []
    }
  ],
  [
    "shape-margin",
    {
      "name": "shape-margin",
      "href": "https://drafts.csswg.org/css-shapes-1/#propdef-shape-margin",
      "initial": "0",
      "appliesTo": "floats and initial letter boxes",
      "inherited": "no",
      "percentages": "refer to the inline size of the containing block",
      "computedValue": "computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "shape-margin",
        "shapeMargin"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "shape-outside",
    {
      "name": "shape-outside",
      "href": "https://drafts.csswg.org/css-shapes-1/#propdef-shape-outside",
      "initial": "none",
      "appliesTo": "floats and initial letter boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as defined for <basic-shape> (with <shape-box> following, if supplied); else the computed <image>; else the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "as defined for <basic-shape>, otherwise discrete",
      "styleDeclaration": [
        "shape-outside",
        "shapeOutside"
      ],
      "syntax": "none | [ <basic-shape> || <shape-box> ] | <image>",
      "extended": []
    }
  ],
  [
    "shape-rendering",
    {
      "name": "shape-rendering",
      "href": "https://svgwg.org/svg2-draft/painting.html#ShapeRenderingProperty",
      "initial": "auto",
      "appliesTo": "shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "shape-rendering",
        "shapeRendering"
      ],
      "syntax": "auto | optimizeSpeed | crispEdges | geometricPrecision",
      "extended": []
    }
  ],
  [
    "slider-orientation",
    {
      "name": "slider-orientation",
      "href": "https://drafts.csswg.org/css-forms-1/#propdef-slider-orientation",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "slider-orientation",
        "sliderOrientation"
      ],
      "syntax": "auto | left-to-right | right-to-left | top-to-bottom | bottom-to-top",
      "extended": []
    }
  ],
  [
    "spatial-navigation-action",
    {
      "name": "spatial-navigation-action",
      "href": "https://drafts.csswg.org/css-nav-1/#propdef-spatial-navigation-action",
      "initial": "auto",
      "appliesTo": "scroll containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "spatial-navigation-action",
        "spatialNavigationAction"
      ],
      "syntax": "auto | focus | scroll",
      "extended": []
    }
  ],
  [
    "spatial-navigation-contain",
    {
      "name": "spatial-navigation-contain",
      "href": "https://drafts.csswg.org/css-nav-1/#propdef-spatial-navigation-contain",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "spatial-navigation-contain",
        "spatialNavigationContain"
      ],
      "syntax": "auto | contain",
      "extended": []
    }
  ],
  [
    "spatial-navigation-function",
    {
      "name": "spatial-navigation-function",
      "href": "https://drafts.csswg.org/css-nav-1/#propdef-spatial-navigation-function",
      "initial": "normal",
      "appliesTo": "spatial navigation containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "spatial-navigation-function",
        "spatialNavigationFunction"
      ],
      "syntax": "normal | grid",
      "extended": []
    }
  ],
  [
    "speak",
    {
      "name": "speak",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-speak",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "speak"
      ],
      "syntax": "auto | never | always",
      "extended": []
    }
  ],
  [
    "speak-as",
    {
      "name": "speak-as",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-speak-as",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "speak-as",
        "speakAs"
      ],
      "syntax": "normal | spell-out || digits || [ literal-punctuation | no-punctuation ]",
      "extended": []
    }
  ],
  [
    "stop-color",
    {
      "name": "stop-color",
      "href": "https://svgwg.org/svg2-draft/pservers.html#StopColorProperty",
      "styleDeclaration": [
        "stop-color",
        "stopColor"
      ],
      "extended": []
    }
  ],
  [
    "stop-opacity",
    {
      "name": "stop-opacity",
      "href": "https://svgwg.org/svg2-draft/pservers.html#StopOpacityProperty",
      "styleDeclaration": [
        "stop-opacity",
        "stopOpacity"
      ],
      "extended": []
    }
  ],
  [
    "string-set",
    {
      "name": "string-set",
      "href": "https://drafts.csswg.org/css-content-3/#propdef-string-set",
      "initial": "none",
      "appliesTo": "all elements, but not pseudo-elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none or a list, each item an identifier paired with a list of string values",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "string-set",
        "stringSet"
      ],
      "syntax": "none | [ <custom-ident> <string>+ ]#",
      "extended": []
    }
  ],
  [
    "stroke",
    {
      "name": "stroke",
      "href": "https://svgwg.org/svg2-draft/painting.html#StrokeProperty",
      "initial": "none",
      "appliesTo": "shapes and text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified, but with <color> values computed and <url> values made absolute",
      "animationType": "by computed value",
      "styleDeclaration": [
        "stroke"
      ],
      "syntax": "<paint>",
      "extended": []
    }
  ],
  [
    "stroke-align",
    {
      "name": "stroke-align",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-align",
      "initial": "center",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-align",
        "strokeAlign"
      ],
      "syntax": "center | inset | outset",
      "extended": []
    }
  ],
  [
    "stroke-alignment",
    {
      "name": "stroke-alignment",
      "href": "https://svgwg.org/specs/strokes/#StrokeAlignmentProperty",
      "initial": "center",
      "appliesTo": "shapes and text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computed value": "as specified",
      "animatable": "yes",
      "styleDeclaration": [
        "stroke-alignment",
        "strokeAlignment"
      ],
      "syntax": "center | inner | outer",
      "extended": []
    }
  ],
  [
    "stroke-break",
    {
      "name": "stroke-break",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-break",
      "initial": "bounding-box",
      "appliesTo": "all elements",
      "inherited": "?",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-break",
        "strokeBreak"
      ],
      "syntax": "bounding-box | slice | clone",
      "extended": []
    }
  ],
  [
    "stroke-color",
    {
      "name": "stroke-color",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-color",
      "initial": "transparent",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "stroke-color",
        "strokeColor"
      ],
      "syntax": "<color>#",
      "extended": []
    }
  ],
  [
    "stroke-dash-corner",
    {
      "name": "stroke-dash-corner",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-dash-corner",
      "initial": "none",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value, with lengths made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value if <length>, otherwise discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-dash-corner",
        "strokeDashCorner"
      ],
      "syntax": "none | <length>",
      "extended": []
    }
  ],
  [
    "stroke-dash-justify",
    {
      "name": "stroke-dash-justify",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-dash-justify",
      "initial": "none",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value, with lengths made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-dash-justify",
        "strokeDashJustify"
      ],
      "syntax": "none | [ stretch | compress ] || [ dashes || gaps ]",
      "extended": []
    }
  ],
  [
    "stroke-dashadjust",
    {
      "name": "stroke-dashadjust",
      "href": "https://svgwg.org/specs/strokes/#StrokeDashadjustProperty",
      "initial": "none",
      "appliesTo": "shapes and text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computed value": "as specified",
      "animatable": "yes",
      "styleDeclaration": [
        "stroke-dashadjust",
        "strokeDashadjust"
      ],
      "syntax": "none | [stretch | compress] [dashes | gaps]?",
      "extended": []
    }
  ],
  [
    "stroke-dasharray",
    {
      "name": "stroke-dasharray",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-dasharray",
      "initial": "none",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "relative to the scaled viewport size",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "stroke-dasharray",
        "strokeDasharray"
      ],
      "syntax": "none | [<length-percentage> | <number>]+#",
      "extended": []
    }
  ],
  [
    "stroke-dashcorner",
    {
      "name": "stroke-dashcorner",
      "href": "https://svgwg.org/specs/strokes/#StrokeDashcornerProperty",
      "initial": "none",
      "appliesTo": "shapes and text content elements",
      "inherited": "yes",
      "percentages": "refer to the size of the current viewport (see Units)",
      "media": "visual",
      "computed value": "absolute length or keyword specified",
      "animatable": "yes",
      "styleDeclaration": [
        "stroke-dashcorner",
        "strokeDashcorner"
      ],
      "syntax": "none | <length>",
      "extended": []
    }
  ],
  [
    "stroke-dashoffset",
    {
      "name": "stroke-dashoffset",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-dashoffset",
      "initial": "0",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "relative to the scaled viewport size",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "stroke-dashoffset",
        "strokeDashoffset"
      ],
      "syntax": "<length-percentage> | <number>",
      "extended": []
    }
  ],
  [
    "stroke-image",
    {
      "name": "stroke-image",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-image",
      "initial": "none",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified, with any <image> computed",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "stroke-image",
        "strokeImage"
      ],
      "syntax": "<paint>#",
      "extended": []
    }
  ],
  [
    "stroke-linecap",
    {
      "name": "stroke-linecap",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-linecap",
      "initial": "butt",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-linecap",
        "strokeLinecap"
      ],
      "syntax": "butt | round | square",
      "extended": []
    }
  ],
  [
    "stroke-linejoin",
    {
      "name": "stroke-linejoin",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-linejoin",
      "initial": "miter",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-linejoin",
        "strokeLinejoin"
      ],
      "syntax": "[ crop | arcs | miter ] || [ bevel | round | fallback ]",
      "extended": []
    }
  ],
  [
    "stroke-miterlimit",
    {
      "name": "stroke-miterlimit",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-miterlimit",
      "initial": "4",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "a number",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-miterlimit",
        "strokeMiterlimit"
      ],
      "syntax": "<number>",
      "extended": []
    }
  ],
  [
    "stroke-opacity",
    {
      "name": "stroke-opacity",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-opacity",
      "initial": "1",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the specified value converted to a <number>, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "stroke-opacity",
        "strokeOpacity"
      ],
      "syntax": "<'opacity'>",
      "extended": []
    }
  ],
  [
    "stroke-origin",
    {
      "name": "stroke-origin",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-origin",
      "initial": "match-parent",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-origin",
        "strokeOrigin"
      ],
      "syntax": "match-parent | fill-box | stroke-box | content-box | padding-box | border-box",
      "extended": []
    }
  ],
  [
    "stroke-position",
    {
      "name": "stroke-position",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-position",
      "initial": "0% 0%",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "A list, each item consisting of: a pair of offsets (horizontal and vertical) from the top left origin each given as a combination of an absolute length and a percentage",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "stroke-position",
        "strokePosition"
      ],
      "syntax": "<position>#",
      "extended": []
    }
  ],
  [
    "stroke-repeat",
    {
      "name": "stroke-repeat",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-repeat",
      "initial": "repeat",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "A list, each item consisting of: two keywords, one per dimension",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "stroke-repeat",
        "strokeRepeat"
      ],
      "syntax": "<repeat-style>#",
      "extended": []
    }
  ],
  [
    "stroke-size",
    {
      "name": "stroke-size",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-size",
      "initial": "auto",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified, but with lengths made absolute and omitted auto keywords filled in",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "media": "visual",
      "styleDeclaration": [
        "stroke-size",
        "strokeSize"
      ],
      "syntax": "<bg-size>#",
      "extended": []
    }
  ],
  [
    "stroke-width",
    {
      "name": "stroke-width",
      "href": "https://drafts.fxtf.org/fill-stroke-3/#propdef-stroke-width",
      "initial": "1px",
      "appliesTo": "text and SVG shapes",
      "inherited": "yes",
      "percentages": "relative to the scaled viewport size",
      "computedValue": "the absolute length, or percentage",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "stroke-width",
        "strokeWidth"
      ],
      "syntax": "[<length-percentage> | <number>]#",
      "extended": []
    }
  ],
  [
    "tab-size",
    {
      "name": "tab-size",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-tab-size",
      "initial": "8",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the specified number or absolute length",
      "canonicalOrder": "n/a",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "tab-size",
        "tabSize"
      ],
      "syntax": "<number [0,∞]> | <length [0,∞]>",
      "extended": []
    }
  ],
  [
    "table-layout",
    {
      "name": "table-layout",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-table-layout",
      "initial": "auto",
      "appliesTo": "table grid boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "table-layout",
        "tableLayout"
      ],
      "syntax": "auto | fixed",
      "extended": []
    }
  ],
  [
    "text-align",
    {
      "name": "text-align",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-align",
      "initial": "start",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "discrete",
      "canonicalOrder": "n/a",
      "styleDeclaration": [
        "text-align",
        "textAlign"
      ],
      "syntax": "start | end | left | right | center | <string> | justify | match-parent | justify-all",
      "extended": []
    }
  ],
  [
    "text-align-all",
    {
      "name": "text-align-all",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-align-all",
      "initial": "start",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "keyword as specified, except for match-parent which computes as defined above",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-align-all",
        "textAlignAll"
      ],
      "syntax": "start | end | left | right | center | <string> | justify | match-parent",
      "extended": []
    }
  ],
  [
    "text-align-last",
    {
      "name": "text-align-last",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-align-last",
      "initial": "auto",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "keyword as specified, except for match-parent which computes as defined above",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-align-last",
        "textAlignLast"
      ],
      "syntax": "auto | start | end | left | right | center | justify | match-parent",
      "extended": []
    }
  ],
  [
    "text-anchor",
    {
      "name": "text-anchor",
      "href": "https://svgwg.org/svg2-draft/text.html#TextAnchorProperty",
      "initial": "start",
      "appliesTo": "text content elements",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-anchor",
        "textAnchor"
      ],
      "syntax": "start | middle | end",
      "extended": []
    }
  ],
  [
    "text-autospace",
    {
      "name": "text-autospace",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-autospace",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-autospace",
        "textAutospace"
      ],
      "syntax": "normal | <autospace> | auto",
      "extended": []
    }
  ],
  [
    "text-box",
    {
      "name": "text-box",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-text-box",
      "initial": "normal",
      "appliesTo": "block containers, multi-column containers, and inline boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-box",
        "textBox"
      ],
      "syntax": "normal | <'text-box-trim'> || <'text-box-edge'>",
      "extended": []
    }
  ],
  [
    "text-box-edge",
    {
      "name": "text-box-edge",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-text-box-edge",
      "initial": "auto",
      "appliesTo": "block containers and inline boxes",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-box-edge",
        "textBoxEdge"
      ],
      "syntax": "auto | <text-edge>",
      "extended": []
    }
  ],
  [
    "text-box-trim",
    {
      "name": "text-box-trim",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-text-box-trim",
      "initial": "none",
      "appliesTo": "block containers, multi-column containers, and inline boxes",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-box-trim",
        "textBoxTrim"
      ],
      "syntax": "none | trim-start | trim-end | trim-both",
      "extended": []
    }
  ],
  [
    "text-combine-upright",
    {
      "name": "text-combine-upright",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-text-combine-upright",
      "initial": "none",
      "appliesTo": "inline boxes and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword, plus integer if digits",
      "canonicalOrder": "n/a",
      "animationType": "not animatable",
      "styleDeclaration": [
        "text-combine-upright",
        "textCombineUpright"
      ],
      "syntax": "none | all | [ digits <integer [2,4]>? ]",
      "extended": []
    }
  ],
  [
    "text-decoration",
    {
      "name": "text-decoration",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "text-decoration",
        "textDecoration"
      ],
      "syntax": "<'text-decoration-line'> || <'text-decoration-thickness'> || <'text-decoration-style'> || <'text-decoration-color'>",
      "extended": []
    }
  ],
  [
    "text-decoration-color",
    {
      "name": "text-decoration-color",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "text-decoration-color",
        "textDecorationColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "text-decoration-line",
    {
      "name": "text-decoration-line",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-line",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no (but see prose, above)",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-line",
        "textDecorationLine"
      ],
      "syntax": "none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",
      "extended": []
    }
  ],
  [
    "text-decoration-skip",
    {
      "name": "text-decoration-skip",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-skip",
      "initial": "See individual properties",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "See individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-skip",
        "textDecorationSkip"
      ],
      "syntax": "none | auto",
      "extended": []
    }
  ],
  [
    "text-decoration-skip-box",
    {
      "name": "text-decoration-skip-box",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-skip-box",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-skip-box",
        "textDecorationSkipBox"
      ],
      "syntax": "none | all",
      "extended": []
    }
  ],
  [
    "text-decoration-skip-ink",
    {
      "name": "text-decoration-skip-ink",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-skip-ink",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-skip-ink",
        "textDecorationSkipInk"
      ],
      "syntax": "auto | none | all",
      "extended": []
    }
  ],
  [
    "text-decoration-skip-self",
    {
      "name": "text-decoration-skip-self",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-skip-self",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword(s) except for skip-all, see below",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-skip-self",
        "textDecorationSkipSelf"
      ],
      "syntax": "auto | skip-all | [ skip-underline || skip-overline || skip-line-through ] | no-skip",
      "extended": []
    }
  ],
  [
    "text-decoration-skip-spaces",
    {
      "name": "text-decoration-skip-spaces",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-skip-spaces",
      "initial": "start end",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-skip-spaces",
        "textDecorationSkipSpaces"
      ],
      "syntax": "none | all | [ start || end ]",
      "extended": []
    }
  ],
  [
    "text-decoration-style",
    {
      "name": "text-decoration-style",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-style",
      "initial": "solid",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-decoration-style",
        "textDecorationStyle"
      ],
      "syntax": "solid | double | dotted | dashed | wavy",
      "extended": []
    }
  ],
  [
    "text-decoration-thickness",
    {
      "name": "text-decoration-thickness",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-decoration-thickness",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "text-decoration-thickness",
        "textDecorationThickness"
      ],
      "syntax": "auto | from-font | <length-percentage>",
      "extended": []
    }
  ],
  [
    "text-emphasis",
    {
      "name": "text-emphasis",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-emphasis",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "text-emphasis",
        "textEmphasis"
      ],
      "syntax": "<'text-emphasis-style'> || <'text-emphasis-color'>",
      "extended": []
    }
  ],
  [
    "text-emphasis-color",
    {
      "name": "text-emphasis-color",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-emphasis-color",
      "initial": "currentcolor",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "text-emphasis-color",
        "textEmphasisColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "text-emphasis-position",
    {
      "name": "text-emphasis-position",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-emphasis-position",
      "initial": "over right",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-emphasis-position",
        "textEmphasisPosition"
      ],
      "syntax": "[ over | under ] && [ right | left ]?",
      "extended": []
    }
  ],
  [
    "text-emphasis-skip",
    {
      "name": "text-emphasis-skip",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-emphasis-skip",
      "initial": "spaces punctuation",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-emphasis-skip",
        "textEmphasisSkip"
      ],
      "syntax": "spaces || punctuation || symbols || narrow",
      "extended": []
    }
  ],
  [
    "text-emphasis-style",
    {
      "name": "text-emphasis-style",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-emphasis-style",
      "initial": "none",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword none, a pair of keywords representing the shape and fill, or a string",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-emphasis-style",
        "textEmphasisStyle"
      ],
      "syntax": "none | [ [ filled | open ] || [ dot | circle | double-circle | triangle | sesame ] ] | <string>",
      "extended": []
    }
  ],
  [
    "text-group-align",
    {
      "name": "text-group-align",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-group-align",
      "initial": "none",
      "appliesTo": "block containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-group-align",
        "textGroupAlign"
      ],
      "syntax": "none | start | end | left | right | center",
      "extended": []
    }
  ],
  [
    "text-indent",
    {
      "name": "text-indent",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-indent",
      "initial": "0",
      "appliesTo": "block containers",
      "inherited": "yes",
      "percentages": "refers to block container’s own inline-axis inner size",
      "computedValue": "computed <length-percentage> value, plus any specified keywords",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "text-indent",
        "textIndent"
      ],
      "syntax": "[ <length-percentage> ] && hanging? && each-line?",
      "extended": []
    }
  ],
  [
    "text-justify",
    {
      "name": "text-justify",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-justify",
      "initial": "auto",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword (except for the distribute legacy value)",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-justify",
        "textJustify"
      ],
      "syntax": "[ auto | none | inter-word | inter-character | ruby ] || no-compress",
      "extended": []
    }
  ],
  [
    "text-orientation",
    {
      "name": "text-orientation",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-text-orientation",
      "initial": "mixed",
      "appliesTo": "all elements except table row groups, rows, column groups, and columns; and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "n/a",
      "animationType": "not animatable",
      "styleDeclaration": [
        "text-orientation",
        "textOrientation"
      ],
      "syntax": "mixed | upright | sideways",
      "extended": []
    }
  ],
  [
    "text-overflow",
    {
      "name": "text-overflow",
      "href": "https://drafts.csswg.org/css-overflow-4/#propdef-text-overflow",
      "initial": "clip",
      "appliesTo": "block containers",
      "inherited": "no",
      "percentages": "refer to the width of the line box",
      "computedValue": "as specified, with lengths made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "text-overflow",
        "textOverflow"
      ],
      "syntax": "[ clip | ellipsis | <string> | fade | <fade()> ]{1,2}",
      "extended": []
    }
  ],
  [
    "text-rendering",
    {
      "name": "text-rendering",
      "href": "https://svgwg.org/svg2-draft/painting.html#TextRenderingProperty",
      "initial": "auto",
      "appliesTo": "‘text’",
      "inherited": "yes",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-rendering",
        "textRendering"
      ],
      "syntax": "auto | optimizeSpeed | optimizeLegibility | geometricPrecision",
      "extended": []
    }
  ],
  [
    "text-shadow",
    {
      "name": "text-shadow",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-shadow",
      "initial": "none",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "either the keyword none or a list, each item consisting of four absolute lengths plus a computed color and optionally also an inset keyword",
      "canonicalOrder": "per grammar",
      "animationType": "as shadow list",
      "styleDeclaration": [
        "text-shadow",
        "textShadow"
      ],
      "syntax": "none | <shadow>#",
      "extended": []
    }
  ],
  [
    "text-spacing",
    {
      "name": "text-spacing",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-spacing",
      "initial": "see individual properties",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "animationType": "discrete",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "text-spacing",
        "textSpacing"
      ],
      "syntax": "none | auto | <spacing-trim> || <autospace>",
      "extended": []
    }
  ],
  [
    "text-spacing-trim",
    {
      "name": "text-spacing-trim",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-spacing-trim",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-spacing-trim",
        "textSpacingTrim"
      ],
      "syntax": "<spacing-trim> | auto",
      "extended": []
    }
  ],
  [
    "text-transform",
    {
      "name": "text-transform",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-transform",
      "initial": "none",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-transform",
        "textTransform"
      ],
      "syntax": "none | [capitalize | uppercase | lowercase ] || full-width || full-size-kana | math-auto",
      "extended": []
    }
  ],
  [
    "text-underline-offset",
    {
      "name": "text-underline-offset",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-underline-offset",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "text-underline-offset",
        "textUnderlineOffset"
      ],
      "syntax": "auto | <length-percentage>",
      "extended": []
    }
  ],
  [
    "text-underline-position",
    {
      "name": "text-underline-position",
      "href": "https://drafts.csswg.org/css-text-decor-4/#propdef-text-underline-position",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-underline-position",
        "textUnderlinePosition"
      ],
      "syntax": "auto | [ from-font | under ] || [ left | right ]",
      "extended": []
    }
  ],
  [
    "text-wrap",
    {
      "name": "text-wrap",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-wrap",
      "initial": "wrap",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "see individual properties",
      "styleDeclaration": [
        "text-wrap",
        "textWrap"
      ],
      "syntax": "<'text-wrap-mode'> || <'text-wrap-style'>",
      "extended": []
    }
  ],
  [
    "text-wrap-mode",
    {
      "name": "text-wrap-mode",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-wrap-mode",
      "initial": "wrap",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-wrap-mode",
        "textWrapMode"
      ],
      "syntax": "wrap | nowrap",
      "extended": []
    }
  ],
  [
    "text-wrap-style",
    {
      "name": "text-wrap-style",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-text-wrap-style",
      "initial": "auto",
      "appliesTo": "block containers hat establish an inline formatting context",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "text-wrap-style",
        "textWrapStyle"
      ],
      "syntax": "auto | balance | stable | pretty | avoid-orphans",
      "extended": []
    }
  ],
  [
    "timeline-scope",
    {
      "name": "timeline-scope",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-timeline-scope",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list of CSS identifiers",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "timeline-scope",
        "timelineScope"
      ],
      "syntax": "none | all | <dashed-ident>#",
      "extended": []
    }
  ],
  [
    "top",
    {
      "name": "top",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-top",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "top"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "transform",
    {
      "name": "transform",
      "href": "https://drafts.csswg.org/css-transforms-1/#propdef-transform",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "refer to the size of reference box",
      "computedValue": "as specified, but with lengths made absolute",
      "canonicalOrder": "per grammar",
      "animationType": "transform list, see interpolation rules",
      "styleDeclaration": [
        "transform"
      ],
      "syntax": "none | <transform-list>",
      "extended": []
    }
  ],
  [
    "transform-box",
    {
      "name": "transform-box",
      "href": "https://drafts.csswg.org/css-transforms-1/#propdef-transform-box",
      "initial": "view-box",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "transform-box",
        "transformBox"
      ],
      "syntax": "content-box | border-box | fill-box | stroke-box | view-box",
      "extended": []
    }
  ],
  [
    "transform-origin",
    {
      "name": "transform-origin",
      "href": "https://drafts.csswg.org/css-transforms-1/#propdef-transform-origin",
      "initial": "50% 50%",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "refer to the size of reference box",
      "computedValue": "see background-position",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "transform-origin",
        "transformOrigin"
      ],
      "syntax": "[ left | center | right | top | bottom | <length-percentage> ] | [ left | center | right | <length-percentage> ] [ top | center | bottom | <length-percentage> ] <length>? | [ [ center | left | right ] && [ center | top | bottom ] ] <length>?",
      "extended": []
    }
  ],
  [
    "transform-style",
    {
      "name": "transform-style",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-transform-style",
      "initial": "flat",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "usedValue": "flat if a grouping property is present, specified keyword otherwise",
      "styleDeclaration": [
        "transform-style",
        "transformStyle"
      ],
      "syntax": "flat | preserve-3d",
      "extended": []
    }
  ],
  [
    "transition",
    {
      "name": "transition",
      "href": "https://drafts.csswg.org/css-transitions-1/#propdef-transition",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "not animatable",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "transition"
      ],
      "syntax": "<single-transition>#",
      "extended": []
    }
  ],
  [
    "transition-behavior",
    {
      "name": "transition-behavior",
      "href": "https://drafts.csswg.org/css-transitions-2/#propdef-transition-behavior",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "transition-behavior",
        "transitionBehavior"
      ],
      "syntax": "<transition-behavior-value>#",
      "extended": []
    }
  ],
  [
    "transition-delay",
    {
      "name": "transition-delay",
      "href": "https://drafts.csswg.org/css-transitions-1/#propdef-transition-delay",
      "initial": "0s",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a duration",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "transition-delay",
        "transitionDelay"
      ],
      "syntax": "<time>#",
      "extended": []
    }
  ],
  [
    "transition-duration",
    {
      "name": "transition-duration",
      "href": "https://drafts.csswg.org/css-transitions-1/#propdef-transition-duration",
      "initial": "0s",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a duration",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "transition-duration",
        "transitionDuration"
      ],
      "syntax": "<time [0s,∞]>#",
      "extended": []
    }
  ],
  [
    "transition-property",
    {
      "name": "transition-property",
      "href": "https://drafts.csswg.org/css-transitions-1/#propdef-transition-property",
      "initial": "all",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the keyword none else a list of identifiers",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "transition-property",
        "transitionProperty"
      ],
      "syntax": "none | <single-transition-property>#",
      "extended": []
    }
  ],
  [
    "transition-timing-function",
    {
      "name": "transition-timing-function",
      "href": "https://drafts.csswg.org/css-transitions-1/#propdef-transition-timing-function",
      "initial": "ease",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "transition-timing-function",
        "transitionTimingFunction"
      ],
      "syntax": "<easing-function>#",
      "extended": []
    }
  ],
  [
    "translate",
    {
      "name": "translate",
      "href": "https://drafts.csswg.org/css-transforms-2/#propdef-translate",
      "initial": "none",
      "appliesTo": "transformable elements",
      "inherited": "no",
      "percentages": "relative to the width of the reference box (for the first value) or the height (for the second value)",
      "computedValue": "the keyword none or a pair of computed <length-percentage> values and an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value, but see below for none",
      "styleDeclaration": [
        "translate"
      ],
      "syntax": "none | <length-percentage> [ <length-percentage> <length>? ]?",
      "extended": []
    }
  ],
  [
    "unicode-bidi",
    {
      "name": "unicode-bidi",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-unicode-bidi",
      "initial": "normal",
      "appliesTo": "all elements, but see prose",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "unicode-bidi",
        "unicodeBidi"
      ],
      "syntax": "normal | embed | isolate | bidi-override | isolate-override | plaintext",
      "extended": []
    }
  ],
  [
    "user-select",
    {
      "name": "user-select",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-user-select",
      "initial": "auto",
      "appliesTo": "all elements, and optionally to the ::before and ::after pseudo-elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "user-select",
        "userSelect"
      ],
      "syntax": "auto | text | none | contain | all",
      "extended": []
    }
  ],
  [
    "vector-effect",
    {
      "name": "vector-effect",
      "href": "https://svgwg.org/svg2-draft/coords.html#VectorEffectProperty",
      "initial": "none",
      "appliesTo": "graphics elements and ‘use’",
      "inherited": "no",
      "percentages": "N/A",
      "media": "visual",
      "computedValue": "as specified",
      "animationType": "discrete",
      "styleDeclaration": [
        "vector-effect",
        "vectorEffect"
      ],
      "syntax": "none | non-scaling-stroke | non-scaling-size | non-rotation | fixed-position",
      "extended": []
    }
  ],
  [
    "vertical-align",
    {
      "name": "vertical-align",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-vertical-align",
      "initial": "baseline",
      "appliesTo": "see individual properties",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "vertical-align",
        "verticalAlign"
      ],
      "syntax": "[ first | last] || <'alignment-baseline'> || <'baseline-shift'>",
      "extended": []
    }
  ],
  [
    "view-timeline",
    {
      "name": "view-timeline",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-view-timeline",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "view-timeline",
        "viewTimeline"
      ],
      "syntax": "[ <'view-timeline-name'> [ <'view-timeline-axis'> || <'view-timeline-inset'> ]? ]#",
      "extended": []
    }
  ],
  [
    "view-timeline-axis",
    {
      "name": "view-timeline-axis",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-view-timeline-axis",
      "initial": "block",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "a list of the keywords specified",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "view-timeline-axis",
        "viewTimelineAxis"
      ],
      "syntax": "[ block | inline | x | y ]#",
      "extended": []
    }
  ],
  [
    "view-timeline-inset",
    {
      "name": "view-timeline-inset",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-view-timeline-inset",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "relative to the corresponding dimension of the relevant scrollport",
      "computedValue": "a list consisting of two-value pairs representing the start and end insets each as either the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "view-timeline-inset",
        "viewTimelineInset"
      ],
      "syntax": "[ [ auto | <length-percentage> ]{1,2} ]#",
      "extended": []
    }
  ],
  [
    "view-timeline-name",
    {
      "name": "view-timeline-name",
      "href": "https://drafts.csswg.org/scroll-animations-1/#propdef-view-timeline-name",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "the keyword none or a list of CSS identifiers",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "view-timeline-name",
        "viewTimelineName"
      ],
      "syntax": "[ none | <dashed-ident> ]#",
      "extended": []
    }
  ],
  [
    "view-transition-class",
    {
      "name": "view-transition-class",
      "href": "https://drafts.csswg.org/css-view-transitions-2/#propdef-view-transition-class",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "view-transition-class",
        "viewTransitionClass"
      ],
      "syntax": "none | <custom-ident>+",
      "extended": []
    }
  ],
  [
    "view-transition-group",
    {
      "name": "view-transition-group",
      "href": "https://drafts.csswg.org/css-view-transitions-2/#propdef-view-transition-group",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "view-transition-group",
        "viewTransitionGroup"
      ],
      "syntax": "normal | contain | nearest | <custom-ident>",
      "extended": []
    }
  ],
  [
    "view-transition-name",
    {
      "name": "view-transition-name",
      "href": "https://drafts.csswg.org/css-view-transitions-2/#propdef-view-transition-name",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "view-transition-name",
        "viewTransitionName"
      ],
      "syntax": "none | <custom-ident>",
      "extended": []
    }
  ],
  [
    "visibility",
    {
      "name": "visibility",
      "href": "https://drafts.csswg.org/css-display-4/#propdef-visibility",
      "initial": "visible",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "media": "visual",
      "styleDeclaration": [
        "visibility"
      ],
      "syntax": "visible | hidden | force-hidden | collapse",
      "extended": []
    }
  ],
  [
    "voice-balance",
    {
      "name": "voice-balance",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-balance",
      "initial": "center",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "the specified value resolved to a <number> between -100 and 100 (inclusive)",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-balance",
        "voiceBalance"
      ],
      "syntax": "<number> | left | center | right | leftwards | rightwards",
      "extended": []
    }
  ],
  [
    "voice-duration",
    {
      "name": "voice-duration",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-duration",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-duration",
        "voiceDuration"
      ],
      "syntax": "auto | <time [0s,∞]>",
      "extended": []
    }
  ],
  [
    "voice-family",
    {
      "name": "voice-family",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-family",
      "initial": "implementation-dependent",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-family",
        "voiceFamily"
      ],
      "syntax": "[[<family-name> | <generic-voice>],]* [<family-name> | <generic-voice>] | preserve",
      "extended": []
    }
  ],
  [
    "voice-pitch",
    {
      "name": "voice-pitch",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-pitch",
      "initial": "medium",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "refer to inherited value",
      "computedValue": "one of the predefined pitch keywords if only the keyword is specified by itself, otherwise an absolute frequency calculated by converting the keyword value (if any) to a fixed frequency based on the current voice-family and by applying the specified relative offset (if any)",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-pitch",
        "voicePitch"
      ],
      "syntax": "<frequency [0Hz,∞]> && absolute | [[x-low | low | medium | high | x-high] || [<frequency> | <semitones> | <percentage>]]",
      "extended": []
    }
  ],
  [
    "voice-range",
    {
      "name": "voice-range",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-range",
      "initial": "medium",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "refer to inherited value",
      "computedValue": "one of the predefined pitch keywords if only the keyword is specified by itself, otherwise an absolute frequency calculated by converting the keyword value (if any) to a fixed frequency based on the current voice-family and by applying the specified relative offset (if any)",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-range",
        "voiceRange"
      ],
      "syntax": "<frequency [0Hz,∞]> && absolute | [[x-low | low | medium | high | x-high] || [<frequency> | <semitones> | <percentage>]]",
      "extended": []
    }
  ],
  [
    "voice-rate",
    {
      "name": "voice-rate",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-rate",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "refer to default value",
      "computedValue": "a keyword value, and optionally also a percentage relative to the keyword (if not 100%)",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-rate",
        "voiceRate"
      ],
      "syntax": "[normal | x-slow | slow | medium | fast | x-fast] || <percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "voice-stress",
    {
      "name": "voice-stress",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-stress",
      "initial": "normal",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-stress",
        "voiceStress"
      ],
      "syntax": "normal | strong | moderate | none | reduced",
      "extended": []
    }
  ],
  [
    "voice-volume",
    {
      "name": "voice-volume",
      "href": "https://drafts.csswg.org/css-speech-1/#propdef-voice-volume",
      "initial": "medium",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "silent, or a keyword value and optionally also a decibel offset (if not zero)",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "voice-volume",
        "voiceVolume"
      ],
      "syntax": "silent | [[x-soft | soft | medium | loud | x-loud] || <decibel>]",
      "extended": []
    }
  ],
  [
    "white-space",
    {
      "name": "white-space",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-white-space",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "see individual properties",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "white-space",
        "whiteSpace"
      ],
      "syntax": "normal | pre | pre-wrap | pre-line | <'white-space-collapse'> || <'text-wrap-mode'> || <'white-space-trim'>",
      "extended": []
    }
  ],
  [
    "white-space-collapse",
    {
      "name": "white-space-collapse",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-white-space-collapse",
      "initial": "collapse",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "white-space-collapse",
        "whiteSpaceCollapse"
      ],
      "syntax": "collapse | discard | preserve | preserve-breaks | preserve-spaces | break-spaces",
      "extended": []
    }
  ],
  [
    "white-space-trim",
    {
      "name": "white-space-trim",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-white-space-trim",
      "initial": "none",
      "appliesTo": "inline boxes and block containers",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword(s)",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "white-space-trim",
        "whiteSpaceTrim"
      ],
      "syntax": "none | discard-before || discard-after || discard-inner",
      "extended": []
    }
  ],
  [
    "widows",
    {
      "name": "widows",
      "href": "https://drafts.csswg.org/css-break-4/#propdef-widows",
      "initial": "2",
      "appliesTo": "block containers that establish an inline formatting context",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified integer",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "widows"
      ],
      "syntax": "<integer [1,∞]>",
      "extended": []
    }
  ],
  [
    "width",
    {
      "name": "width",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-width",
      "initial": "auto",
      "appliesTo": "all elements except non-replaced inlines",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type, recursing into fit-content()",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "width"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "will-change",
    {
      "name": "will-change",
      "href": "https://drafts.csswg.org/css-will-change-1/#propdef-will-change",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "not animatable",
      "styleDeclaration": [
        "will-change",
        "willChange"
      ],
      "syntax": "auto | <animateable-feature>#",
      "extended": []
    }
  ],
  [
    "word-break",
    {
      "name": "word-break",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-word-break",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "word-break",
        "wordBreak"
      ],
      "syntax": "normal | break-all | keep-all | manual | auto-phrase | break-word",
      "extended": []
    }
  ],
  [
    "word-space-transform",
    {
      "name": "word-space-transform",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-word-space-transform",
      "initial": "none",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "word-space-transform",
        "wordSpaceTransform"
      ],
      "syntax": "none | [ space | ideographic-space ] && auto-phrase?",
      "extended": []
    }
  ],
  [
    "word-spacing",
    {
      "name": "word-spacing",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-word-spacing",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "relative to computed font-size, i.e. 1em",
      "computedValue": "an absolute length and/or a percentage",
      "canonicalOrder": "n/a",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "word-spacing",
        "wordSpacing"
      ],
      "syntax": "normal | <length-percentage>",
      "extended": []
    }
  ],
  [
    "word-wrap",
    {
      "name": "word-wrap",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-word-wrap",
      "initial": "normal",
      "appliesTo": "text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "n/a",
      "animationType": "discrete",
      "styleDeclaration": [
        "word-wrap",
        "wordWrap"
      ],
      "syntax": "normal | break-word | anywhere",
      "extended": []
    }
  ],
  [
    "wrap-after",
    {
      "name": "wrap-after",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-wrap-after",
      "initial": "auto",
      "appliesTo": "inline-level boxes and flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "wrap-after",
        "wrapAfter"
      ],
      "syntax": "auto | avoid | avoid-line | avoid-flex | line | flex",
      "extended": []
    }
  ],
  [
    "wrap-before",
    {
      "name": "wrap-before",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-wrap-before",
      "initial": "auto",
      "appliesTo": "inline-level boxes and flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "wrap-before",
        "wrapBefore"
      ],
      "syntax": "auto | avoid | avoid-line | avoid-flex | line | flex",
      "extended": []
    }
  ],
  [
    "wrap-flow",
    {
      "name": "wrap-flow",
      "href": "https://drafts.csswg.org/css-exclusions-1/#propdef-wrap-flow",
      "initial": "auto",
      "appliesTo": "block-level elements.",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified except for element’s whose float computed value is not none, in which case the computed value is auto.",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "wrap-flow",
        "wrapFlow"
      ],
      "syntax": "auto | both | start | end | minimum | maximum | clear",
      "extended": []
    }
  ],
  [
    "wrap-inside",
    {
      "name": "wrap-inside",
      "href": "https://drafts.csswg.org/css-text-4/#propdef-wrap-inside",
      "initial": "auto",
      "appliesTo": "inline boxes",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "wrap-inside",
        "wrapInside"
      ],
      "syntax": "auto | avoid",
      "extended": []
    }
  ],
  [
    "wrap-through",
    {
      "name": "wrap-through",
      "href": "https://drafts.csswg.org/css-exclusions-1/#propdef-wrap-through",
      "initial": "wrap",
      "appliesTo": "block-level elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "wrap-through",
        "wrapThrough"
      ],
      "syntax": "wrap | none",
      "extended": []
    }
  ],
  [
    "writing-mode",
    {
      "name": "writing-mode",
      "href": "https://drafts.csswg.org/css-writing-modes-4/#propdef-writing-mode",
      "initial": "horizontal-tb",
      "appliesTo": "All elements except table row groups, table column groups, table rows, table columns, ruby base containers, ruby annotation containers",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "n/a",
      "animationType": "not animatable",
      "styleDeclaration": [
        "writing-mode",
        "writingMode"
      ],
      "syntax": "horizontal-tb | vertical-rl | vertical-lr | sideways-rl | sideways-lr",
      "extended": []
    }
  ],
  [
    "z-index",
    {
      "name": "z-index",
      "href": "https://drafts.csswg.org/css2/#propdef-z-index",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "media": "visual",
      "styleDeclaration": [
        "z-index",
        "zIndex"
      ],
      "syntax": "auto | <integer> | inherit",
      "extended": []
    }
  ]
]);
