# テストガイド

## テスト戦略

西濃追跡チェッカーはChrome拡張機能という特性上、以下の3層構造でテストを行っています。

### カバレッジ対象

- **utils/common.js**: ユーティリティ関数（100%カバレッジ達成済み）
  - 伝票番号のバリデーション
  - 文字列処理関数
  - 日時フォーマット関数

### カバレッジ除外対象

以下のファイルはChrome APIやDOMに深く依存しており、単体テストでのカバレッジ測定が困難なため除外しています：

- **background.js**: Service Worker（chrome.runtime API依存）
- **content.js**: Content Script（DOM解析、chrome.tabs API依存）
- **popup.js**: Popup UI（DOM操作依存）

これらのファイルは統合テストと手動テストで動作を保証しています。

### テスト構成

```
src/
├── utils/
│   ├── common.js           # ユーティリティ関数（ユニットテスト対象）
│   └── common.test.js      # ユニットテスト
├── integration/
│   └── tracking.test.js    # 統合テスト（166件）
└── __tests__/
    └── setup.js            # テスト環境設定
```

## テスト実行

### 全テスト実行

```bash
npm test
```

### カバレッジレポート生成

```bash
npm run test:coverage
```

カバレッジレポートは `coverage/index.html` で確認できます。

### ウォッチモード

```bash
npm run test:watch
```

ファイル変更時に自動でテストが再実行されます。

## カバレッジ目標

| メトリクス | 目標 | 現状 |
|-----------|------|------|
| Lines | 80% | 100% (utils/common.js) |
| Functions | 80% | 100% (utils/common.js) |
| Branches | 80% | 100% (utils/common.js) |
| Statements | 80% | 100% (utils/common.js) |

## 手動テスト

Chrome拡張機能として実際にインストールして動作確認を行います。

### テスト手順

1. **拡張機能のインストール**
   ```bash
   chrome://extensions/
   デベロッパーモード → パッケージ化されていない拡張機能を読み込む
   ```

2. **右クリックメニューからの追跡**
   - 伝票番号を選択
   - 右クリック → 「西濃運輸で追跡」
   - 結果が正しく表示されることを確認

3. **複数伝票番号の入力**
   - ポップアップを開く
   - カンマ区切り・改行区切りで複数の伝票番号を入力
   - 「追跡する」ボタンをクリック
   - 全ての結果が正しく表示されることを確認

4. **履歴機能**
   - 検索結果が履歴に保存されることを確認
   - 過去の履歴を表示できることを確認

5. **ステータス表示**
   - 各ステータスが正しい色で表示されることを確認
     - 到着済み: 緑
     - 配達中: オレンジ
     - 集荷済: 青
     - その他: グレー

## 統合テスト

統合テスト（166件）では、以下のシナリオをカバーしています：

- 正常な伝票番号の処理
- 異常な伝票番号の処理
- 複数伝票番号の一括処理
- エラーハンドリング
- 境界値テスト

## CI/CD

GitHub Actionsで自動テストを実行しています：

```yaml
- ユニットテストの実行
- カバレッジレポートの生成
- 80%カバレッジのチェック
```

## トラブルシューティング

### テストが失敗する場合

1. **依存関係の再インストール**
   ```bash
   rm -rf node_modules package-lock.json
   npm install
   ```

2. **キャッシュのクリア**
   ```bash
   npm run test:clear-cache
   ```

3. **Chrome拡張機能の再読み込み**
   - chrome://extensions/ で「再読み込み」ボタンをクリック

### カバレッジが下がった場合

1. カバレッジレポートを確認
   ```bash
   open coverage/index.html
   ```

2. 未カバーの行を特定し、テストを追加

3. PRを作成前にカバレッジ80%以上を確認

## 関連ドキュメント

- [README](./README) - プロジェクト概要
- [vitest.config.js](./vitest.config.js) - テスト設定
