# 西濃追跡チェッカー リリースノート

## v1.2.0 (2026-01-23)

### 改良

#### コード品質向上
- コードレビューを実施し、15件の問題を修正
- 共通ユーティリティモジュール（`src/utils/common.js`）を作成
- 定数化（マジックナンバーを排除）
- 重複コードの削除（8個の関数を削除）
- エラーハンドリングの改善（console.error出力追加）

#### セキュリティ強化
- XSS対策：HTMLエスケープ関数を実装（`escapeHtml`）
- ユーザー入力の適切なエスケープ処理

#### パフォーマンス改善
- Service Workerのアイドルタイムアウト対策（進捗状態の永続化）
- MutationObserverのクリーンアップ改善
- イベントリスナー管理の最適化

#### テストカバレッジ
- ユニットテスト導入（Vitest + jsdom）
- テスト数：166件（全件パス）
- カバレッジ：100%（utils/common.js）

#### バグ修正
- Service WorkerのES6 importエラーを修正
- Content Scriptの`importScripts is not defined`エラーを修正
- 送り状No読み込み機能の回復

### 技術仕様の変更

| 項目 | 変更内容 |
|------|----------|
| パーミッション | `notifications`を追加 |
| Content Script読み込み順序 | `common.js` → `content.js`の順に変更 |
| モジュール構成 | 共通ユーティリティを別ファイルに分離 |

### ファイル構成の変更

```
seino-tracker-extension/
├── manifest.json          (バージョン 1.2.0)
├── vitest.config.js       (新規: テスト設定)
├── TESTING.md             (新規: テスト戦略ドキュメント)
└── src/
    ├── utils/
    │   ├── common.js      (新規: 共通ユーティリティ)
    │   └── common.test.js (新規: ユニットテスト)
    ├── __tests__/
    │   └── setup.js       (新規: テスト環境セットアップ)
    ├── integration/
    │   └── extension.test.js (新規: 統合テスト)
    ├── background/
    │   └── background.js  (リファクタリング)
    ├── content/
    │   ├── content.js     (リファクタリング)
    │   ├── content.js.test.js (新規)
    │   └── content.css
    └── popup/
        ├── popup.html
        ├── popup.css
        ├── popup.js       (リファクタリング)
        └── popup.js.test.js (新規)
```

### 既知の制限（変更なし）

- 西濃運輸のサイト構造変更により動作しなくなる可能性あり
- 追跡情報のスクレイピングのため、HTML構造変更に要注意
- 伝票番号の形式（10〜12桁）を前提としている

### 今後の改善予定

- [ ] ステータス判定の精度向上（Playwright対応）
- [ ] 他の運送会社対応
- [ ] 通知機能（Slack連携）
- [ ] E2Eテスト導入（Playwright）

---

*リリース日: 2026-01-23*
*バージョン: 1.2.0*
*状態: 安定版*

## v1.0.0 (2026-01-08)

### 機能

#### 伝票番号追跡
- 選択したテキストから伝票番号を自動抽出
- 西濃運輸の追跡サービスで到着状況を確認
- 複数伝票番号の一括追跡対応

#### 右クリックメニュー
- 選択範囲から伝票番号を抽出して追跡
- ページ内の全伝票番号を自動抽出して追跡

#### ポップアップUI
- 追跡結果の一覧表示
- 履歴保存（最大50件）
- ステータス別の色分け表示
- コピー機能（伝票番号・ステータス）

#### ステータス判定
| 状態 | メッセージ | 色 |
|------|-----------|-----|
| エラー | 入力されたお問合せ番号が見当りません | 赤 |
| 完了 | 配達済みです | 緑 |
| 配達中 | 配達中です | 青 |
| 輸送中 | 輸送中です | 青 |

#### 除外ルール
- 電話番号（0始まり）を自動除外
- タイムアウト設定（30秒）

### 技術仕様

| 項目 | 内容 |
|------|------|
| Manifest Version | 3 |
| パーミッション | activeTab, contextMenus, storage, scripting |
| ホスト権限 | https://track.seino.co.jp/* |
| ストレージ | chrome.storage.local（最大50件） |
| 対応サイト | 全サイト（content scriptでテキスト抽出） |

### ファイル構成

```
seino-tracker-extension/
├── manifest.json          (Manifest V3)
├── icons/
│   ├── icon16.png
│   ├── icon48.png
│   └── icon128.png
└── src/
    ├── background/
    │   └── background.js  (Service Worker, 右クリックメニュー)
    ├── content/
    │   ├── content.js     (ページ内テキスト抽出)
    │   └── content.css
    └── popup/
        ├── popup.html     (メインUI)
        ├── popup.css
        └── popup.js       (追跡処理、履歴管理)
```

### Skillドキュメント

- `skills/seino-tracker-extension.md` - 使用方法・インストール手順

### インストール方法

1. `chrome://extensions/` を開く
2. 「デベロッパーモード」をオン
3. 「パッケージ化されていない拡張機能を読み込む」
4. `dev/seino-tracker-extension/` フォルダを選択

### 既知の制限

- 西濃運輸のサイト構造変更により動作しなくなる可能性あり
- 追跡情報のスクレイピングのため、HTML構造変更に要注意
- 伝票番号の形式（11〜12桁）を前提としている

### 今後の改善予定

- [ ] ステータス判定の精度向上（Playwright対応 Issue #115）
- [ ] 他の運送会社対応
- [ ] 通知機能（Slack連携）

---

*リリース日: 2026-01-08*
*バージョン: 1.0.0*
*状態: FIX版*
